/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.aop.SpringProxy;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.projection.TargetAware;
import org.springframework.graphql.data.ArgumentValue;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.BatchMapping;
import org.springframework.graphql.data.method.annotation.SchemaMapping;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerConfigurer;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class SchemaMappingBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)SchemaMappingBeanFactoryInitializationAotProcessor.class.getClassLoader());

    SchemaMappingBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Class[] controllerTypes = (Class[])Arrays.stream(beanFactory.getBeanDefinitionNames()).map(beanName -> RegisteredBean.of((ConfigurableListableBeanFactory)beanFactory, (String)beanName).getBeanClass()).filter(this::isController).toArray(Class[]::new);
        return new SchemaMappingBeanFactoryInitializationAotContribution(controllerTypes);
    }

    private boolean isController(AnnotatedElement element) {
        return MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(Controller.class);
    }

    private static class SchemaMappingBeanFactoryInitializationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Class<?>[] controllers;
        private final HandlerMethodArgumentResolverComposite argumentResolvers;

        public SchemaMappingBeanFactoryInitializationAotContribution(Class<?>[] controllers) {
            this.controllers = controllers;
            this.argumentResolvers = this.createArgumentResolvers();
        }

        private HandlerMethodArgumentResolverComposite createArgumentResolvers() {
            AnnotatedControllerConfigurer controllerConfigurer = new AnnotatedControllerConfigurer();
            controllerConfigurer.setApplicationContext((ApplicationContext)new StaticApplicationContext());
            controllerConfigurer.afterPropertiesSet();
            HandlerMethodArgumentResolverComposite argumentResolverComposite = controllerConfigurer.getArgumentResolvers();
            Assert.notNull((Object)argumentResolverComposite, (String)"argument resolvers should not be null");
            return argumentResolverComposite;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            this.registerSpringDataSpelSupport(runtimeHints);
            Arrays.stream(this.controllers).forEach(controller -> {
                runtimeHints.reflection().registerType(controller, new MemberCategory[0]);
                ReflectionUtils.doWithMethods((Class)controller, method -> this.processSchemaMappingMethod(runtimeHints, method), this::isGraphQlHandlerMethod);
            });
        }

        private void registerSpringDataSpelSupport(RuntimeHints runtimeHints) {
            if (springDataPresent) {
                runtimeHints.reflection().registerType(SpelAwareProxyProjectionFactory.class, new MemberCategory[0]).registerType(TypeReference.of((String)"org.springframework.data.projection.SpelEvaluatingMethodInterceptor$TargetWrapper"), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}));
            }
        }

        private boolean isGraphQlHandlerMethod(AnnotatedElement element) {
            MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
            return mergedAnnotations.isPresent(SchemaMapping.class) || mergedAnnotations.isPresent(BatchMapping.class);
        }

        private void processSchemaMappingMethod(RuntimeHints runtimeHints, Method method) {
            runtimeHints.reflection().registerMethod(method, ExecutableMode.INVOKE);
            for (Parameter parameter : method.getParameters()) {
                this.processMethodParameter(runtimeHints, MethodParameter.forParameter((Parameter)parameter));
            }
            this.processReturnType(runtimeHints, MethodParameter.forExecutable((Executable)method, (int)-1));
        }

        private void processMethodParameter(RuntimeHints runtimeHints, MethodParameter methodParameter) {
            MethodParameterRuntimeHintsRegistrar.fromMethodParameter(this.argumentResolvers, methodParameter).apply(runtimeHints);
        }

        private void processReturnType(RuntimeHints runtimeHints, MethodParameter methodParameter) {
            new ArgumentBindingHints(methodParameter).apply(runtimeHints);
        }
    }

    private static class ProjectedPayloadHints
    implements MethodParameterRuntimeHintsRegistrar {
        private final MethodParameter methodParameter;

        public ProjectedPayloadHints(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public void apply(RuntimeHints runtimeHints) {
            Class parameterType = this.methodParameter.nestedIfOptional().getNestedParameterType();
            runtimeHints.reflection().registerType(parameterType, new MemberCategory[0]);
            runtimeHints.proxies().registerJdkProxy(new Class[]{parameterType, TargetAware.class, SpringProxy.class, DecoratingProxy.class});
        }
    }

    private static class DataLoaderHints
    implements MethodParameterRuntimeHintsRegistrar {
        private final MethodParameter methodParameter;

        public DataLoaderHints(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public void apply(RuntimeHints runtimeHints) {
            bindingRegistrar.registerReflectionHints(runtimeHints.reflection(), new Type[]{this.methodParameter.nested().getNestedGenericParameterType()});
        }
    }

    private static class ArgumentBindingHints
    implements MethodParameterRuntimeHintsRegistrar {
        private final MethodParameter methodParameter;

        public ArgumentBindingHints(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public void apply(RuntimeHints runtimeHints) {
            Type parameterType = this.methodParameter.getGenericParameterType();
            if (ArgumentValue.class.isAssignableFrom(this.methodParameter.getParameterType())) {
                parameterType = this.methodParameter.nested().getNestedGenericParameterType();
            }
            bindingRegistrar.registerReflectionHints(runtimeHints.reflection(), new Type[]{parameterType});
        }
    }

    private static class NoHintsRequired
    implements MethodParameterRuntimeHintsRegistrar {
        private NoHintsRequired() {
        }

        @Override
        public void apply(RuntimeHints runtimeHints) {
        }
    }

    @FunctionalInterface
    private static interface MethodParameterRuntimeHintsRegistrar {
        public static final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

        public void apply(RuntimeHints var1);

        public static MethodParameterRuntimeHintsRegistrar fromMethodParameter(HandlerMethodArgumentResolverComposite argumentResolvers, MethodParameter methodParameter) {
            HandlerMethodArgumentResolver argumentResolver = argumentResolvers.getArgumentResolver(methodParameter);
            if (argumentResolver instanceof ArgumentMethodArgumentResolver || argumentResolver instanceof ArgumentsMethodArgumentResolver) {
                return new ArgumentBindingHints(methodParameter);
            }
            if (argumentResolver instanceof DataLoaderMethodArgumentResolver) {
                return new DataLoaderHints(methodParameter);
            }
            if (springDataPresent && argumentResolver instanceof ProjectedPayloadMethodArgumentResolver) {
                return new ProjectedPayloadHints(methodParameter);
            }
            return new NoHintsRequired();
        }
    }
}

