/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import org.apache.solr.client.solrj.SolrClient;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.schema.SolrPersistentEntitySchemaCreator;
import org.springframework.data.solr.repository.query.PartTreeSolrQuery;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.query.SolrQueryMethod;
import org.springframework.data.solr.repository.query.StringBasedSolrQuery;
import org.springframework.data.solr.repository.support.SimpleSolrRepository;
import org.springframework.data.solr.repository.support.SolrEntityInformationCreatorImpl;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SolrRepositoryFactory
extends RepositoryFactorySupport {
    private SolrOperations solrOperations;
    private final SolrEntityInformationCreator entityInformationCreator;
    @Nullable
    private SolrClientFactory factory;
    private SolrTemplateHolder templateHolder = new SolrTemplateHolder();
    private boolean schemaCreationSupport;

    public SolrRepositoryFactory(SolrOperations solrOperations) {
        Assert.notNull((Object)solrOperations, (String)"SolrOperations must not be null!");
        if (solrOperations instanceof SolrTemplate) {
            this.addSchemaCreationFeaturesIfEnabled((SolrTemplate)solrOperations);
        }
        this.solrOperations = solrOperations;
        this.entityInformationCreator = new SolrEntityInformationCreatorImpl(solrOperations.getConverter().getMappingContext());
    }

    public SolrRepositoryFactory(SolrClient solrClient) {
        Assert.notNull((Object)solrClient, (String)"SolrClient must not be null!");
        this.solrOperations = this.createTemplate(solrClient, null);
        this.factory = new HttpSolrClientFactory(solrClient);
        this.entityInformationCreator = new SolrEntityInformationCreatorImpl(this.solrOperations.getConverter().getMappingContext());
    }

    public SolrRepositoryFactory(SolrClient solrClient, SolrConverter converter) {
        Assert.notNull((Object)solrClient, (String)"SolrClient must not be null!");
        this.solrOperations = this.createTemplate(solrClient, converter);
        this.factory = new HttpSolrClientFactory(solrClient);
        this.entityInformationCreator = new SolrEntityInformationCreatorImpl(this.solrOperations.getConverter().getMappingContext());
    }

    private SolrTemplate createTemplate(SolrClient solrClient, @Nullable SolrConverter converter) {
        SolrTemplate template = new SolrTemplate(solrClient);
        if (converter != null) {
            template.setSolrConverter(converter);
        }
        this.addSchemaCreationFeaturesIfEnabled(template);
        template.afterPropertiesSet();
        return template;
    }

    public <T, ID> SolrEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.entityInformationCreator.getEntityInformation(domainClass);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        SolrOperations operations = this.solrOperations;
        if (this.factory != null) {
            SolrTemplate template = new SolrTemplate(this.factory);
            if (this.solrOperations.getConverter() != null) {
                template.setMappingContext(this.solrOperations.getConverter().getMappingContext());
                template.setSolrConverter(this.solrOperations.getConverter());
            }
            this.addSchemaCreationFeaturesIfEnabled(template);
            template.afterPropertiesSet();
            operations = template;
        }
        SimpleSolrRepository repository = (SimpleSolrRepository)this.getTargetRepositoryViaReflection(metadata, new Object[]{operations, this.getEntityInformation(metadata.getDomainType())});
        this.templateHolder.add(metadata.getDomainType(), operations);
        return repository;
    }

    private void addSchemaCreationFeaturesIfEnabled(SolrTemplate template) {
        if (this.isSchemaCreationSupport()) {
            template.setSchemaCreationFeatures(Collections.singletonList(SolrPersistentEntitySchemaCreator.Feature.CREATE_MISSING_FIELDS));
        }
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (SolrRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        return SimpleSolrRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new SolrQueryLookupStrategy());
    }

    public boolean isSchemaCreationSupport() {
        return this.schemaCreationSupport;
    }

    public void setSchemaCreationSupport(boolean schemaCreationSupport) {
        this.schemaCreationSupport = schemaCreationSupport;
    }

    private static class SolrTemplateHolder {
        private Map<Class<?>, SolrOperations> operationsMap = new WeakHashMap();

        private SolrTemplateHolder() {
        }

        void add(Class<?> domainType, SolrOperations repository) {
            this.operationsMap.put(domainType, repository);
        }

        SolrOperations getSolrOperations(Class<?> type) {
            return this.operationsMap.get(type);
        }
    }

    private class SolrQueryLookupStrategy
    implements QueryLookupStrategy {
        private SolrQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            SolrQueryMethod queryMethod = new SolrQueryMethod(method, metadata, factory, SolrRepositoryFactory.this.entityInformationCreator);
            String namedQueryName = queryMethod.getNamedQueryName();
            String collectionName = SolrRepositoryFactory.this.getEntityInformation(metadata.getDomainType()).getCollectionName();
            SolrOperations solrOperations = this.selectSolrOperations(metadata);
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedSolrQuery(collectionName, namedQuery, queryMethod, solrOperations);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedSolrQuery(collectionName, queryMethod, solrOperations);
            }
            return new PartTreeSolrQuery(collectionName, queryMethod, solrOperations);
        }

        private SolrOperations selectSolrOperations(RepositoryMetadata metadata) {
            SolrOperations ops = SolrRepositoryFactory.this.templateHolder.getSolrOperations(metadata.getDomainType());
            if (ops == null) {
                ops = SolrRepositoryFactory.this.solrOperations;
            }
            return ops;
        }
    }
}

