/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import org.springframework.data.domain.Pageable;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleFacetQuery
extends SimpleQuery
implements FacetQuery {
    @Nullable
    private FacetOptions facetOptions;

    public SimpleFacetQuery() {
    }

    public SimpleFacetQuery(Criteria criteria) {
        this(criteria, null);
    }

    public SimpleFacetQuery(Criteria criteria, @Nullable Pageable pageable) {
        super(criteria, pageable);
    }

    @Override
    public final <T extends SolrDataQuery> T setFacetOptions(FacetOptions facetOptions) {
        if (facetOptions != null) {
            Assert.isTrue((boolean)facetOptions.hasFacets(), (String)"Cannot set facet options having neither fields nor queries.");
        }
        this.facetOptions = facetOptions;
        return (T)this;
    }

    @Override
    @Nullable
    public FacetOptions getFacetOptions() {
        return this.facetOptions;
    }

    @Override
    public boolean hasFacetOptions() {
        return this.getFacetOptions() != null;
    }
}

