/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwareSortArgumentResolver
implements HandlerMethodArgumentResolver,
SortArgumentResolver {
    private final JacksonMappingAwareSortTranslator translator;
    private final SortArgumentResolver delegate;

    public MappingAwareSortArgumentResolver(JacksonMappingAwareSortTranslator translator, SortArgumentResolver delegate) {
        Assert.notNull((Object)translator, (String)"JacksonMappingAwareSortTranslator must not be null!");
        Assert.notNull((Object)delegate, (String)"Delegate SortArgumentResolver must not be null!");
        this.translator = translator;
        this.delegate = delegate;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return this.delegate.supportsParameter(parameter);
    }

    public Sort resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Sort sort = this.delegate.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        return sort.isUnsorted() ? sort : this.translator.translateSort(sort, methodParameter, webRequest);
    }
}

