/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.util.Assert;

public class ProjectionDefinitionRegistar
extends InstantiationAwareBeanPostProcessorAdapter {
    private final ObjectFactory<RepositoryRestConfiguration> config;

    public ProjectionDefinitionRegistar(ObjectFactory<RepositoryRestConfiguration> config) {
        Assert.notNull(config, (String)"RepositoryRestConfiguration must not be null!");
        this.config = config;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof ResourceMappings)) {
            return bean;
        }
        ResourceMappings mappings = (ResourceMappings)bean;
        for (ResourceMetadata resourceMetadata : mappings) {
            Optional projection = resourceMetadata.getExcerptProjection();
            projection.ifPresent(it -> {
                Class[] classArray;
                Projection annotation = (Projection)AnnotationUtils.findAnnotation((Class)it, Projection.class);
                if (annotation == null) {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = resourceMetadata.getDomainType();
                } else {
                    classArray = annotation.types();
                }
                Class[] target = classArray;
                ((RepositoryRestConfiguration)this.config.getObject()).getProjectionConfiguration().addProjection(it, target);
            });
        }
        return bean;
    }
}

