/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.data.rest.core.RepositoryConstraintViolationException;
import org.springframework.util.Assert;
import org.springframework.validation.FieldError;

public class RepositoryConstraintViolationExceptionMessage {
    private final List<ValidationError> errors = new ArrayList<ValidationError>();

    public RepositoryConstraintViolationExceptionMessage(RepositoryConstraintViolationException exception, MessageSourceAccessor accessor) {
        Assert.notNull((Object)exception, (String)"RepositoryConstraintViolationException must not be null!");
        Assert.notNull((Object)accessor, (String)"MessageSourceAccessor must not be null!");
        for (FieldError fieldError : exception.getErrors().getFieldErrors()) {
            this.errors.add(ValidationError.of(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), accessor.getMessage((MessageSourceResolvable)fieldError)));
        }
    }

    @JsonProperty(value="errors")
    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public static final class ValidationError {
        private final String entity;
        private final String property;
        private final Object invalidValue;
        private final String message;

        private ValidationError(String entity, String property, Object invalidValue, String message) {
            this.entity = entity;
            this.property = property;
            this.invalidValue = invalidValue;
            this.message = message;
        }

        public static ValidationError of(String entity, String property, Object invalidValue, String message) {
            return new ValidationError(entity, property, invalidValue, message);
        }

        public String getEntity() {
            return this.entity;
        }

        public String getProperty() {
            return this.property;
        }

        public Object getInvalidValue() {
            return this.invalidValue;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValidationError)) {
                return false;
            }
            ValidationError other = (ValidationError)o;
            String this$entity = this.getEntity();
            String other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            String this$property = this.getProperty();
            String other$property = other.getProperty();
            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                return false;
            }
            Object this$invalidValue = this.getInvalidValue();
            Object other$invalidValue = other.getInvalidValue();
            if (this$invalidValue == null ? other$invalidValue != null : !this$invalidValue.equals(other$invalidValue)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            String $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : $property.hashCode());
            Object $invalidValue = this.getInvalidValue();
            result = result * 59 + ($invalidValue == null ? 43 : $invalidValue.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "RepositoryConstraintViolationExceptionMessage.ValidationError(entity=" + this.getEntity() + ", property=" + this.getProperty() + ", invalidValue=" + this.getInvalidValue() + ", message=" + this.getMessage() + ")";
        }
    }
}

