/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.convert;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StringUtils;

public class UriListHttpMessageConverter
implements HttpMessageConverter<ResourceSupport> {
    private static final List<MediaType> MEDIA_TYPES = new ArrayList<MediaType>();

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (null == mediaType) {
            return false;
        }
        return ResourceSupport.class.isAssignableFrom(clazz) && mediaType.getSubtype().contains("uri-list");
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return MEDIA_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceSupport read(Class<? extends ResourceSupport> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        ArrayList<Link> links = new ArrayList<Link>();
        try (Scanner scanner = new Scanner(inputMessage.getBody());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!StringUtils.hasText((String)line)) continue;
                links.add(new Link(line));
            }
        }
        return new Resources(Collections.emptyList(), links);
    }

    public void write(ResourceSupport resource, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputMessage.getBody()));
        for (Link link : resource.getLinks()) {
            writer.write(link.getHref());
            writer.newLine();
        }
        writer.flush();
    }

    static {
        MEDIA_TYPES.add(MediaType.parseMediaType((String)"text/uri-list"));
    }
}

