/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.CollectionFactory;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RepositoryRestController
class RepositoryPropertyReferenceController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}/{id}/{property}";
    private static final Collection<HttpMethod> AUGMENTING_METHODS = Arrays.asList(HttpMethod.PATCH, HttpMethod.POST);
    private final Repositories repositories;
    private final RepositoryInvokerFactory repositoryInvokerFactory;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryPropertyReferenceController(Repositories repositories, RepositoryInvokerFactory repositoryInvokerFactory, PagedResourcesAssembler<Object> assembler) {
        super(assembler);
        this.repositories = repositories;
        this.repositoryInvokerFactory = repositoryInvokerFactory;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, PersistentEntityResourceAssembler assembler) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                return this.toResources((Iterable)it, assembler, prop.propertyType, Optional.empty());
            }
            if (prop.property.isMap()) {
                HashMap resources = new HashMap();
                for (Map.Entry entry : ((Map)it).entrySet()) {
                    resources.put(entry.getKey(), assembler.toResource(entry.getValue()));
                }
                return new Resource(resources, new Link[0]);
            }
            PersistentEntityResource resource = assembler.toResource(it);
            headers.set("Content-Location", resource.getId().getHref());
            return resource;
        }).orElseThrow(() -> new ResourceNotFoundException());
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    public ResponseEntity<? extends ResourceSupport> deletePropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property) throws Exception {
        Function<ReferencedProperty, ResourceSupport> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike() || prop.property.isMap()) {
                throw HttpRequestMethodNotSupportedException.forRejectedMethod(HttpMethod.DELETE).withAllowedMethods(HttpMethod.GET, HttpMethod.HEAD);
            }
            prop.wipeValue();
            this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.accessor.getBean(), prop.propertyValue));
            Object result = repoRequest.getInvoker().invokeSave(prop.accessor.getBean());
            this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
            return null;
        }).orElse(null);
        this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, @PathVariable String propertyId, PersistentEntityResourceAssembler assembler) throws Exception {
        HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                for (Object obj : (Iterable)it) {
                    IdentifierAccessor accessor1 = prop.entity.getIdentifierAccessor(obj);
                    if (!propertyId.equals(accessor1.getIdentifier().toString())) continue;
                    PersistentEntityResource resource1 = assembler.toResource(obj);
                    headers.set("Content-Location", resource1.getId().getHref());
                    return resource1;
                }
            } else if (prop.property.isMap()) {
                for (Map.Entry entry : ((Map)it).entrySet()) {
                    IdentifierAccessor accessor2 = prop.entity.getIdentifierAccessor(entry.getValue());
                    if (!propertyId.equals(accessor2.getIdentifier().toString())) continue;
                    PersistentEntityResource resource2 = assembler.toResource(entry.getValue());
                    headers.set("Content-Location", resource2.getId().getHref());
                    return resource2;
                }
            } else {
                return new Resource(prop.propertyValue, new Link[0]);
            }
            throw new ResourceNotFoundException();
        }).orElseThrow(() -> new ResourceNotFoundException());
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, this.doWithReferencedProperty(repoRequest, id, property, handler, HttpMethod.GET));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<ResourceSupport> followPropertyReferenceCompact(RootResourceInformation repoRequest, @BackendId Serializable id, @PathVariable String property, PersistentEntityResourceAssembler assembler) throws Exception {
        ResponseEntity<ResourceSupport> response = this.followPropertyReference(repoRequest, id, property, assembler);
        if (response.getStatusCode() != HttpStatus.OK) {
            return response;
        }
        ResourceMetadata repoMapping = repoRequest.getResourceMetadata();
        PersistentProperty persistentProp = repoRequest.getPersistentEntity().getRequiredPersistentProperty(property);
        ResourceMapping propertyMapping = repoMapping.getMappingFor(persistentProp);
        ResourceSupport resource = (ResourceSupport)response.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        ControllerLinkBuilder linkBuilder = ControllerLinkBuilder.linkTo(((RepositoryPropertyReferenceController)ControllerLinkBuilder.methodOn(RepositoryPropertyReferenceController.class, (Object[])new Object[0])).followPropertyReference(repoRequest, id, property, assembler));
        if (resource instanceof Resource) {
            Object content = ((Resource)resource).getContent();
            if (content instanceof Iterable) {
                for (Resource res : (Iterable)content) {
                    links.add(linkBuilder.withRel(propertyMapping.getRel()));
                }
            } else if (content instanceof Map) {
                Map map = (Map)content;
                for (Map.Entry entry : map.entrySet()) {
                    Link l = new Link(((Resource)entry.getValue()).getLink("self").getHref(), entry.getKey().toString());
                    links.add(l);
                }
            }
        } else {
            links.add(linkBuilder.withRel(propertyMapping.getRel()));
        }
        return ControllerUtils.toResponseEntity(HttpStatus.OK, null, new Resource(ControllerUtils.EMPTY_RESOURCE_LIST, links));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.POST}, consumes={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<? extends ResourceSupport> createPropertyReference(RootResourceInformation resourceInformation, HttpMethod requestMethod, @RequestBody(required=false) Resources<Object> incoming, @BackendId Serializable id, @PathVariable String property) throws Exception {
        Resources source = incoming == null ? new Resources(Collections.emptyList(), new Link[0]) : incoming;
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Function<ReferencedProperty, ResourceSupport> handler = prop -> {
            Class propertyType = prop.property.getType();
            if (prop.property.isCollectionLike()) {
                Collection collection = AUGMENTING_METHODS.contains(requestMethod) ? (Collection)prop.propertyValue : CollectionFactory.createCollection((Class)propertyType, (int)0);
                for (Link l1 : source.getLinks()) {
                    collection.add(this.loadPropertyValue(prop.propertyType, l1));
                }
                prop.accessor.setProperty(prop.property, (Object)collection);
            } else if (prop.property.isMap()) {
                Map map = AUGMENTING_METHODS.contains(requestMethod) ? (Map)prop.propertyValue : CollectionFactory.createMap((Class)propertyType, (int)0);
                for (Link l2 : source.getLinks()) {
                    map.put(l2.getRel(), this.loadPropertyValue(prop.propertyType, l2));
                }
                prop.accessor.setProperty(prop.property, (Object)map);
            } else {
                if (HttpMethod.PATCH.equals((Object)requestMethod)) {
                    throw HttpRequestMethodNotSupportedException.forRejectedMethod(HttpMethod.PATCH).withAllowedMethods(HttpMethod.PATCH).withMessage("Cannot PATCH a reference to this singular property since the property type is not a List or a Map.", new Object[0]);
                }
                if (source.getLinks().size() != 1) {
                    throw new IllegalArgumentException("Must send only 1 link to update a property reference that isn't a List or a Map.");
                }
                prop.accessor.setProperty(prop.property, this.loadPropertyValue(prop.propertyType, (Link)source.getLinks().get(0)));
            }
            this.publisher.publishEvent((ApplicationEvent)new BeforeLinkSaveEvent(prop.accessor.getBean(), prop.propertyValue));
            Object result = invoker.invokeSave(prop.accessor.getBean());
            this.publisher.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(result, prop.propertyValue));
            return null;
        };
        this.doWithReferencedProperty(resourceInformation, id, property, handler, requestMethod);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<ResourceSupport> deletePropertyReferenceId(RootResourceInformation repoRequest, @BackendId Serializable backendId, @PathVariable String property, @PathVariable String propertyId) throws Exception {
        Function<ReferencedProperty, ResourceSupport> handler = prop -> prop.mapValue(it -> {
            if (prop.property.isCollectionLike()) {
                Collection coll = (Collection)it;
                Iterator iterator = coll.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    Optional.ofNullable(prop.entity.getIdentifierAccessor(obj).getIdentifier()).map(Object::toString).filter(id -> propertyId.equals(id)).ifPresent(__ -> iterator.remove());
                }
            } else if (prop.property.isMap()) {
                Map m = (Map)it;
                Iterator iterator = m.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next().getKey();
                    Optional.ofNullable(prop.entity.getIdentifierAccessor(m.get(key)).getIdentifier()).map(Object::toString).filter(id -> propertyId.equals(id)).ifPresent(__ -> iterator.remove());
                }
            } else {
                prop.wipeValue();
            }
            this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.accessor.getBean(), it));
            Object result = repoRequest.getInvoker().invokeSave(prop.accessor.getBean());
            this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, it));
            return null;
        }).orElse(null);
        this.doWithReferencedProperty(repoRequest, backendId, property, handler, HttpMethod.DELETE);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    private Object loadPropertyValue(Class<?> type, Link link) {
        String href = link.expand(new Object[0]).getHref();
        String id = href.substring(href.lastIndexOf(47) + 1);
        RepositoryInvoker invoker = this.repositoryInvokerFactory.getInvokerFor(type);
        return invoker.invokeFindById((Object)id).orElse(null);
    }

    private Optional<ResourceSupport> doWithReferencedProperty(RootResourceInformation resourceInformation, Serializable id, String propertyPath, Function<ReferencedProperty, ResourceSupport> handler, HttpMethod method) throws Exception {
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        PropertyAwareResourceMapping mapping = metadata.getProperty(propertyPath);
        if (mapping == null || !mapping.isExported()) {
            throw new ResourceNotFoundException();
        }
        PersistentProperty property = mapping.getProperty();
        resourceInformation.verifySupportedMethod(method, property);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Optional domainObj = invoker.invokeFindById((Object)id);
        domainObj.orElseThrow(() -> new ResourceNotFoundException());
        return domainObj.map(it -> {
            PersistentPropertyAccessor accessor = property.getOwner().getPropertyAccessor(it);
            return (ResourceSupport)handler.apply(new ReferencedProperty(property, accessor.getProperty(property), accessor));
        });
    }

    @ExceptionHandler
    public ResponseEntity<Void> handle(HttpRequestMethodNotSupportedException exception) {
        return exception.toResponse();
    }

    static class HttpRequestMethodNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = 3704212056962845475L;
        private final HttpMethod rejectedMethod;
        private final HttpMethod[] allowedMethods;
        private final String message;

        public static HttpRequestMethodNotSupportedException forRejectedMethod(HttpMethod method) {
            return new HttpRequestMethodNotSupportedException(method, new HttpMethod[0], null);
        }

        public HttpRequestMethodNotSupportedException withAllowedMethods(HttpMethod ... methods) {
            return new HttpRequestMethodNotSupportedException(this.rejectedMethod, (HttpMethod[])methods.clone(), null);
        }

        public HttpRequestMethodNotSupportedException withMessage(String message, Object ... parameters) {
            return new HttpRequestMethodNotSupportedException(this.rejectedMethod, this.allowedMethods, String.format(message, parameters));
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public ResponseEntity<Void> toResponse() {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).allow(this.allowedMethods)).build();
        }

        private HttpRequestMethodNotSupportedException(HttpMethod rejectedMethod, HttpMethod[] allowedMethods, String message) {
            this.rejectedMethod = rejectedMethod;
            this.allowedMethods = allowedMethods;
            this.message = message;
        }
    }

    private class ReferencedProperty {
        final PersistentEntity<?, ?> entity;
        final PersistentProperty<?> property;
        final Class<?> propertyType;
        final Object propertyValue;
        final PersistentPropertyAccessor accessor;

        private ReferencedProperty(PersistentProperty<?> property, Object propertyValue, PersistentPropertyAccessor wrapper) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.accessor = wrapper;
            this.propertyType = property.getActualType();
            this.entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(this.propertyType);
        }

        public void wipeValue() {
            this.accessor.setProperty(this.property, null);
        }

        public <T> Optional<T> mapValue(Function<Object, T> function) {
            return Optional.ofNullable(this.propertyValue).map(function);
        }
    }
}

