/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.util.Assert;

public class Table
extends AbstractSegment
implements TableLike {
    private final SqlIdentifier name;

    Table(String name) {
        super(new Segment[0]);
        this.name = SqlIdentifier.unquoted(name);
    }

    Table(SqlIdentifier name) {
        super(new Segment[0]);
        this.name = name;
    }

    public static Table create(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        return new Table(name);
    }

    public static Table create(SqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Table(name);
    }

    public static Table aliased(String name, String alias) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedTable(name, alias);
    }

    public Table as(String alias) {
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedTable(this.name, SqlIdentifier.unquoted(alias));
    }

    public Table as(SqlIdentifier alias) {
        Assert.notNull((Object)alias, (String)"Alias must not be null");
        return new AliasedTable(this.name, alias);
    }

    @Override
    public SqlIdentifier getName() {
        return this.name;
    }

    @Override
    public SqlIdentifier getReferenceName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Table table = (Table)o;
        return this.name.equals(table.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    static class AliasedTable
    extends Table
    implements Aliased {
        private final SqlIdentifier alias;

        AliasedTable(String name, String alias) {
            super(name);
            Assert.hasText((String)alias, (String)"Alias must not be null or empty");
            this.alias = SqlIdentifier.unquoted(alias);
        }

        AliasedTable(SqlIdentifier name, SqlIdentifier alias) {
            super(name);
            Assert.notNull((Object)alias, (String)"Alias must not be null");
            this.alias = alias;
        }

        @Override
        public SqlIdentifier getAlias() {
            return this.alias;
        }

        @Override
        public SqlIdentifier getReferenceName() {
            return this.getAlias();
        }

        @Override
        public String toString() {
            return String.valueOf(this.getName()) + " AS " + String.valueOf(this.getAlias());
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AliasedTable that = (AliasedTable)o;
            return this.alias.equals(that.alias);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.alias);
        }
    }
}

