/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.NumberToBooleanConverter;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.dialect.TimestampAtUtcToOffsetDateTimeConverter;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;

public class MySqlDialect
extends AbstractDialect {
    @Deprecated(forRemoval=true, since="4.0")
    public static final IdentifierProcessing MYSQL_IDENTIFIER_PROCESSING = IdentifierProcessing.create(new IdentifierProcessing.Quoting("`"), IdentifierProcessing.LetterCasing.LOWER_CASE);
    @Deprecated(forRemoval=true)
    public static final MySqlDialect INSTANCE = new MySqlDialect();
    private final IdentifierProcessing identifierProcessing;
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return String.format("LIMIT %d, 18446744073709551615", offset);
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %s, %s", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private static final LockClause LOCK_CLAUSE = new LockClause(){

        @Override
        public String getLock(LockOptions lockOptions) {
            switch (lockOptions.getLockMode()) {
                case PESSIMISTIC_WRITE: {
                    return "FOR UPDATE";
                }
                case PESSIMISTIC_READ: {
                    return "LOCK IN SHARE MODE";
                }
            }
            return "";
        }

        @Override
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    };

    protected MySqlDialect() {
        this(MYSQL_IDENTIFIER_PROCESSING);
    }

    public MySqlDialect(IdentifierProcessing identifierProcessing) {
        Assert.notNull((Object)identifierProcessing, (String)"IdentifierProcessing must not be null");
        this.identifierProcessing = identifierProcessing;
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return LOCK_CLAUSE;
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return this.identifierProcessing;
    }

    @Override
    public Collection<Object> getConverters() {
        return Arrays.asList(new Object[]{TimestampAtUtcToOffsetDateTimeConverter.INSTANCE, NumberToBooleanConverter.INSTANCE});
    }

    @Override
    public OrderByNullPrecedence orderByNullHandling() {
        return OrderByNullPrecedence.NONE;
    }

    @Override
    public IdGeneration getIdGeneration() {
        return new IdGeneration(){

            @Override
            public boolean sequencesSupported() {
                return false;
            }

            @Override
            public String createSequenceQuery(SqlIdentifier sequenceName) {
                throw new UnsupportedOperationException("Currently, there is no support for sequence generation for %s dialect. If you need it, please, submit a ticket".formatted(this.getClass().getSimpleName()));
            }
        };
    }
}

