/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class ObjectPath {
    public static final ObjectPath ROOT = new ObjectPath();
    @Nullable
    private final ObjectPath parent;
    @Nullable
    private final Object object;

    private ObjectPath() {
        this.parent = null;
        this.object = null;
    }

    private ObjectPath(ObjectPath parent, Object object) {
        this.parent = parent;
        this.object = object;
    }

    ObjectPath push(Object object, RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)object, (String)"Object must not be null");
        Assert.notNull(entity, (String)"RelationalPersistentEntity must not be null");
        return new ObjectPath(this, object);
    }

    @Nullable
    Object getCurrentObject() {
        return this.getObject();
    }

    @Nullable
    private Object getObject() {
        return this.object;
    }

    public String toString() {
        if (this.parent == null) {
            return "[empty]";
        }
        ArrayList<String> strings = new ArrayList<String>();
        ObjectPath current = this;
        while (current != null) {
            strings.add(ObjectUtils.nullSafeToString((Object)current.getObject()));
            current = current.parent;
        }
        return StringUtils.collectionToDelimitedString(strings, (String)" -> ");
    }
}

