/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.support;

import java.util.regex.Pattern;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class TableNameQueryPreprocessor {
    private static final String EXPRESSION_PARAMETER = "$1#{";
    private static final String QUOTED_EXPRESSION_PARAMETER = "$1__HASH__{";
    private static final Pattern EXPRESSION_PARAMETER_QUOTING = Pattern.compile("([:?])#\\{");
    private static final Pattern EXPRESSION_PARAMETER_UNQUOTING = Pattern.compile("([:?])__HASH__\\{");
    private final SqlIdentifier tableName;
    private final SqlIdentifier qualifiedTableName;
    private final Dialect dialect;

    public TableNameQueryPreprocessor(RelationalPersistentEntity<?> entity, Dialect dialect) {
        this(entity.getTableName(), entity.getQualifiedTableName(), dialect);
    }

    TableNameQueryPreprocessor(SqlIdentifier tableName, SqlIdentifier qualifiedTableName, Dialect dialect) {
        Assert.notNull((Object)tableName, (String)"TableName must not be null");
        Assert.notNull((Object)qualifiedTableName, (String)"QualifiedTableName must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        this.tableName = tableName;
        this.qualifiedTableName = qualifiedTableName;
        this.dialect = dialect;
    }

    public String transform(String query) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setVariable("tableName", (Object)this.tableName.toSql(this.dialect.getIdentifierProcessing()));
        evaluationContext.setVariable("qualifiedTableName", (Object)this.qualifiedTableName.toSql(this.dialect.getIdentifierProcessing()));
        SpelExpressionParser parser = new SpelExpressionParser();
        query = TableNameQueryPreprocessor.quoteExpressionsParameter(query);
        Expression expression = parser.parseExpression(query, ParserContext.TEMPLATE_EXPRESSION);
        return TableNameQueryPreprocessor.unquoteParameterExpressions((String)expression.getValue((EvaluationContext)evaluationContext, String.class));
    }

    private static String unquoteParameterExpressions(String result) {
        return EXPRESSION_PARAMETER_UNQUOTING.matcher(result).replaceAll(EXPRESSION_PARAMETER);
    }

    private static String quoteExpressionsParameter(String query) {
        return EXPRESSION_PARAMETER_QUOTING.matcher(query).replaceAll(QUOTED_EXPRESSION_PARAMETER);
    }
}

