/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.util.Assert;

public class Between
extends AbstractSegment
implements Condition {
    private final Expression column;
    private final Expression begin;
    private final Expression end;
    private final boolean negated;

    private Between(Expression column, Expression begin, Expression end, boolean negated) {
        super(column, begin, end);
        this.column = column;
        this.begin = begin;
        this.end = end;
        this.negated = negated;
    }

    public static Between create(Expression columnOrExpression, Expression begin, Expression end) {
        Assert.notNull((Object)columnOrExpression, (String)"Column or expression must not be null");
        Assert.notNull((Object)begin, (String)"Begin value must not be null");
        Assert.notNull((Object)end, (String)"end value must not be null");
        return new Between(columnOrExpression, begin, end, false);
    }

    public Expression getColumn() {
        return this.column;
    }

    public Expression getBegin() {
        return this.begin;
    }

    public Expression getEnd() {
        return this.end;
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public Between not() {
        return new Between(this.column, this.begin, this.end, !this.negated);
    }

    @Override
    public String toString() {
        return String.valueOf(this.column) + (this.negated ? " NOT" : "") + " BETWEEN " + String.valueOf(this.begin) + " AND " + String.valueOf(this.end);
    }
}

