/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.Arrays;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class CompositeSqlIdentifier
implements SqlIdentifier {
    private final SqlIdentifier[] parts;

    CompositeSqlIdentifier(SqlIdentifier ... parts) {
        Assert.notNull((Object)parts, (String)"SqlIdentifier parts must not be null");
        Assert.noNullElements((Object[])parts, (String)"SqlIdentifier parts must not contain null elements");
        Assert.isTrue((parts.length > 0 ? 1 : 0) != 0, (String)"SqlIdentifier parts must not be empty");
        this.parts = parts;
    }

    public Iterator<SqlIdentifier> iterator() {
        return Arrays.asList(this.parts).iterator();
    }

    @Override
    public SqlIdentifier transform(UnaryOperator<String> transformationFunction) {
        throw new UnsupportedOperationException("Composite SQL Identifiers cannot be transformed");
    }

    @Override
    public String toSql(IdentifierProcessing processing) {
        StringJoiner stringJoiner = new StringJoiner(".");
        for (SqlIdentifier namePart : this.parts) {
            stringJoiner.add(namePart.toSql(processing));
        }
        return stringJoiner.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SqlIdentifier) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.toSql(IdentifierProcessing.ANSI);
    }
}

