/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.AggregatePathTableUtils;
import org.springframework.data.relational.core.mapping.AggregatePathTraversal;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface AggregatePath
extends Iterable<AggregatePath> {
    public AggregatePath getParentPath();

    public AggregatePath append(RelationalPersistentProperty var1);

    public boolean isRoot();

    default public int getLength() {
        return 1 + (this.isRoot() ? 0 : this.getRequiredPersistentPropertyPath().getLength());
    }

    public boolean isWritable();

    public boolean isEntity();

    public boolean isEmbedded();

    public boolean isMultiValued();

    public boolean isQualified();

    public boolean isMap();

    public boolean isCollectionLike();

    public boolean isOrdered();

    public boolean hasIdProperty();

    public RelationalPersistentProperty getRequiredIdProperty();

    public PersistentPropertyPath<RelationalPersistentProperty> getRequiredPersistentPropertyPath();

    default public RelationalPersistentProperty getRequiredBaseProperty() {
        return (RelationalPersistentProperty)this.getRequiredPersistentPropertyPath().getBaseProperty();
    }

    default public RelationalPersistentProperty getRequiredLeafProperty() {
        return (RelationalPersistentProperty)this.getRequiredPersistentPropertyPath().getLeafProperty();
    }

    @Nullable
    public RelationalPersistentEntity<?> getLeafEntity();

    default public RelationalPersistentEntity<?> getRequiredLeafEntity() {
        RelationalPersistentEntity<?> entity = this.getLeafEntity();
        if (entity == null) {
            throw new IllegalStateException(String.format("Couldn't resolve leaf PersistentEntity for type %s", this.getRequiredLeafProperty().getActualType()));
        }
        return entity;
    }

    public String toDotPath();

    default public TableInfo getTableInfo() {
        return TableInfo.of(this);
    }

    default public ColumnInfo getColumnInfo() {
        return ColumnInfo.of(this);
    }

    @Nullable
    default public AggregatePath filter(Predicate<? super AggregatePath> predicate) {
        for (AggregatePath item : this) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    default public Stream<AggregatePath> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public AggregatePath getIdDefiningParentPath();

    public record TableInfo(SqlIdentifier qualifiedTableName, @Nullable SqlIdentifier tableAlias, ColumnInfo reverseColumnInfo, @Nullable ColumnInfo qualifierColumnInfo, @Nullable Class<?> qualifierColumnType, SqlIdentifier idColumnName, SqlIdentifier effectiveIdColumnName) {
        static TableInfo of(AggregatePath path) {
            SqlIdentifier keyColumn;
            AggregatePath tableOwner = AggregatePathTraversal.getTableOwningPath(path);
            RelationalPersistentEntity<?> leafEntity = tableOwner.getRequiredLeafEntity();
            SqlIdentifier qualifiedTableName = leafEntity.getQualifiedTableName();
            SqlIdentifier tableAlias = tableOwner.isRoot() ? null : AggregatePathTableUtils.constructTableAlias(tableOwner);
            ColumnInfo reverseColumnInfo = null;
            if (!tableOwner.isRoot()) {
                AggregatePath idDefiningParentPath = tableOwner.getIdDefiningParentPath();
                RelationalPersistentProperty leafProperty = tableOwner.getRequiredLeafProperty();
                SqlIdentifier reverseColumnName = leafProperty.getReverseColumnName(idDefiningParentPath.getRequiredLeafEntity());
                reverseColumnInfo = new ColumnInfo(reverseColumnName, AggregatePathTableUtils.prefixWithTableAlias(path, reverseColumnName));
            }
            ColumnInfo qualifierColumnInfo = null;
            if (!path.isRoot() && (keyColumn = path.getRequiredLeafProperty().getKeyColumn()) != null) {
                qualifierColumnInfo = new ColumnInfo(keyColumn, keyColumn);
            }
            Class<?> qualifierColumnType = null;
            if (!path.isRoot() && path.getRequiredLeafProperty().isQualified()) {
                qualifierColumnType = path.getRequiredLeafProperty().getQualifierColumnType();
            }
            SqlIdentifier idColumnName = leafEntity.hasIdProperty() ? leafEntity.getIdColumn() : null;
            SqlIdentifier effectiveIdColumnName = tableOwner.isRoot() ? idColumnName : reverseColumnInfo.name();
            return new TableInfo(qualifiedTableName, tableAlias, reverseColumnInfo, qualifierColumnInfo, qualifierColumnType, idColumnName, effectiveIdColumnName);
        }
    }

    public record ColumnInfo(SqlIdentifier name, SqlIdentifier alias) {
        static ColumnInfo of(AggregatePath path) {
            Assert.notNull((Object)path, (String)"AggregatePath must not be null");
            Assert.isTrue((!path.isRoot() ? 1 : 0) != 0, () -> "Cannot obtain ColumnInfo for root path");
            Assert.isTrue((!path.isEmbedded() ? 1 : 0) != 0, () -> "Cannot obtain ColumnInfo for embedded path");
            SqlIdentifier columnName = path.getRequiredLeafProperty().getColumnName();
            return new ColumnInfo(columnName, AggregatePathTableUtils.prefixWithTableAlias(path, columnName));
        }
    }
}

