/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.util.Assert;

public class Functions {
    private Functions() {
    }

    public static SimpleFunction coalesce(Expression ... expressions) {
        return SimpleFunction.create("COALESCE", Arrays.asList(expressions));
    }

    public static SimpleFunction count(Expression ... columns) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        Assert.notEmpty((Object[])columns, (String)"Columns must contains at least one column");
        return SimpleFunction.create("COUNT", Arrays.asList(columns));
    }

    public static SimpleFunction count(Collection<? extends Expression> columns) {
        Assert.notNull(columns, (String)"Columns must not be null");
        return SimpleFunction.create("COUNT", new ArrayList<Expression>(columns));
    }

    public static SimpleFunction greatest(Expression ... expressions) {
        return Functions.greatest(Arrays.asList(expressions));
    }

    public static SimpleFunction greatest(List<? extends Expression> expressions) {
        return SimpleFunction.create("GREATEST", expressions);
    }

    public static SimpleFunction least(Expression ... expressions) {
        return SimpleFunction.create("LEAST", Arrays.asList(expressions));
    }

    public static SimpleFunction lower(Expression expression) {
        Assert.notNull((Object)expression, (String)"Columns must not be null");
        return SimpleFunction.create("LOWER", Collections.singletonList(expression));
    }

    public static SimpleFunction upper(Expression expression) {
        Assert.notNull((Object)expression, (String)"Expression must not be null");
        return SimpleFunction.create("UPPER", Collections.singletonList(expression));
    }
}

