/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.AggregatePathTraversal;
import org.springframework.data.relational.core.sql.SqlIdentifier;

class AggregatePathTableUtils {
    AggregatePathTableUtils() {
    }

    public static SqlIdentifier prefixWithTableAlias(AggregatePath path, SqlIdentifier columnName) {
        AggregatePath tableOwner = AggregatePathTraversal.getTableOwningPath(path);
        SqlIdentifier tableAlias = tableOwner.isRoot() ? null : AggregatePathTableUtils.constructTableAlias(tableOwner);
        return tableAlias == null ? columnName : columnName.transform(name -> tableAlias.getReference() + "_" + name);
    }

    public static SqlIdentifier constructTableAlias(AggregatePath path) {
        String alias = path.stream().filter(p -> !p.isRoot()).map(p -> p.isEmbedded() ? p.getRequiredLeafProperty().getEmbeddedPrefix() : p.getRequiredLeafProperty().getName() + (p == path ? "" : "_")).collect(new ReverseJoinCollector());
        return SqlIdentifier.quoted(alias);
    }

    private static class ReverseJoinCollector
    implements Collector<String, StringBuilder, String> {
        private ReverseJoinCollector() {
        }

        @Override
        public Supplier<StringBuilder> supplier() {
            return StringBuilder::new;
        }

        @Override
        public BiConsumer<StringBuilder, String> accumulator() {
            return (stringBuilder, s) -> stringBuilder.insert(0, (String)s);
        }

        @Override
        public BinaryOperator<StringBuilder> combiner() {
            return (a, b) -> b.append((CharSequence)a);
        }

        @Override
        public Function<StringBuilder, String> finisher() {
            return StringBuilder::toString;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

