/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.data.mapping.Association;
import org.springframework.data.relational.core.mapping.EmbeddedContext;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class EmbeddedRelationalPersistentProperty
implements RelationalPersistentProperty {
    private final RelationalPersistentProperty delegate;
    private final EmbeddedContext context;

    public EmbeddedRelationalPersistentProperty(RelationalPersistentProperty delegate, EmbeddedContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    @Override
    public boolean isEmbedded() {
        return this.delegate.isEmbedded();
    }

    @Override
    @Nullable
    public String getEmbeddedPrefix() {
        return this.context.withEmbeddedPrefix(this.delegate.getEmbeddedPrefix());
    }

    @Override
    public SqlIdentifier getColumnName() {
        return this.delegate.getColumnName().transform(this.context::withEmbeddedPrefix);
    }

    @Override
    public boolean hasExplicitColumnName() {
        return this.delegate.hasExplicitColumnName();
    }

    @Override
    public RelationalPersistentEntity<?> getOwner() {
        return this.delegate.getOwner();
    }

    @Override
    @Deprecated(since="3.2", forRemoval=true)
    public SqlIdentifier getReverseColumnName(PersistentPropertyPathExtension path) {
        return this.delegate.getReverseColumnName(path);
    }

    @Override
    public SqlIdentifier getReverseColumnName(RelationalPersistentEntity<?> owner) {
        return this.delegate.getReverseColumnName(owner);
    }

    @Override
    @Nullable
    public SqlIdentifier getKeyColumn() {
        return this.delegate.getKeyColumn();
    }

    @Override
    public boolean isQualified() {
        return this.delegate.isQualified();
    }

    @Override
    public Class<?> getQualifierColumnType() {
        return this.delegate.getQualifierColumnType();
    }

    @Override
    public boolean isOrdered() {
        return this.delegate.isOrdered();
    }

    @Override
    public boolean shouldCreateEmptyEmbedded() {
        return this.delegate.shouldCreateEmptyEmbedded();
    }

    @Override
    public boolean isInsertOnly() {
        return this.delegate.isInsertOnly();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Class<?> getType() {
        return this.delegate.getType();
    }

    public TypeInformation<?> getTypeInformation() {
        return this.delegate.getTypeInformation();
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return this.delegate.getPersistentEntityTypeInformation();
    }

    @Nullable
    public Method getGetter() {
        return this.delegate.getGetter();
    }

    @Nullable
    public Method getSetter() {
        return this.delegate.getSetter();
    }

    @Nullable
    public Method getWither() {
        return this.delegate.getWither();
    }

    @Nullable
    public Field getField() {
        return this.delegate.getField();
    }

    @Nullable
    public String getSpelExpression() {
        return this.delegate.getSpelExpression();
    }

    @Nullable
    public Association<RelationalPersistentProperty> getAssociation() {
        return this.delegate.getAssociation();
    }

    public Association<RelationalPersistentProperty> getRequiredAssociation() {
        return this.delegate.getRequiredAssociation();
    }

    public boolean isEntity() {
        return this.delegate.isEntity();
    }

    public boolean isIdProperty() {
        return this.delegate.isIdProperty();
    }

    public boolean isVersionProperty() {
        return this.delegate.isVersionProperty();
    }

    public boolean isCollectionLike() {
        return this.delegate.isCollectionLike();
    }

    public boolean isMap() {
        return this.delegate.isMap();
    }

    public boolean isArray() {
        return this.delegate.isArray();
    }

    public boolean isTransient() {
        return this.delegate.isTransient();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isImmutable() {
        return this.delegate.isImmutable();
    }

    public boolean isAssociation() {
        return this.delegate.isAssociation();
    }

    @Nullable
    public Class<?> getComponentType() {
        return this.delegate.getComponentType();
    }

    public Class<?> getRawType() {
        return this.delegate.getRawType();
    }

    @Nullable
    public Class<?> getMapValueType() {
        return this.delegate.getMapValueType();
    }

    public Class<?> getActualType() {
        return this.delegate.getActualType();
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return (A)this.delegate.findAnnotation(annotationType);
    }

    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return (A)this.delegate.findPropertyOrOwnerAnnotation(annotationType);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType);
    }

    public boolean usePropertyAccess() {
        return this.delegate.usePropertyAccess();
    }

    public boolean hasActualTypeAnnotation(Class<? extends Annotation> annotationType) {
        return this.delegate.hasActualTypeAnnotation(annotationType);
    }

    @Nullable
    public Class<?> getAssociationTargetType() {
        return this.delegate.getAssociationTargetType();
    }

    @Nullable
    public TypeInformation<?> getAssociationTargetTypeInformation() {
        return this.delegate.getAssociationTargetTypeInformation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddedRelationalPersistentProperty that = (EmbeddedRelationalPersistentProperty)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.delegate, (Object)that.delegate)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.context, (Object)that.context);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.delegate);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.context);
        return result;
    }

    public String toString() {
        return this.delegate.toString();
    }
}

