/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.InsertRenderContext;
import org.springframework.data.relational.core.dialect.InsertRenderContexts;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.dialect.SqlServerSelectRenderContext;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.data.util.Lazy;

public class SqlServerDialect
extends AbstractDialect {
    public static final SqlServerDialect INSTANCE = new SqlServerDialect();
    private static final IdGeneration ID_GENERATION = new IdGeneration(){

        @Override
        public boolean supportedForBatchOperations() {
            return false;
        }
    };
    private static final IdentifierProcessing IDENTIFIER_PROCESSING = IdentifierProcessing.create(IdentifierProcessing.Quoting.ANSI, IdentifierProcessing.LetterCasing.AS_IS);
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "OFFSET 0 ROWS FETCH NEXT " + limit + " ROWS ONLY";
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset + " ROWS";
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private static final LockClause LOCK_CLAUSE = new LockClause(){

        @Override
        public String getLock(LockOptions lockOptions) {
            switch (lockOptions.getLockMode()) {
                case PESSIMISTIC_WRITE: {
                    return "WITH (UPDLOCK, ROWLOCK)";
                }
                case PESSIMISTIC_READ: {
                    return "WITH (HOLDLOCK, ROWLOCK)";
                }
            }
            return "";
        }

        @Override
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_FROM_TABLE;
        }
    };
    private final Lazy<SelectRenderContext> selectRenderContext = Lazy.of(() -> new SqlServerSelectRenderContext(this.getAfterFromTable(), this.getAfterOrderBy()));

    protected SqlServerDialect() {
    }

    @Override
    public IdGeneration getIdGeneration() {
        return ID_GENERATION;
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return LOCK_CLAUSE;
    }

    @Override
    public Escaper getLikeEscaper() {
        return Escaper.DEFAULT.withRewriteFor("[", "]");
    }

    @Override
    public SelectRenderContext getSelectContext() {
        return (SelectRenderContext)this.selectRenderContext.get();
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return IDENTIFIER_PROCESSING;
    }

    @Override
    public InsertRenderContext getInsertRenderContext() {
        return InsertRenderContexts.MS_SQL_SERVER;
    }

    @Override
    public OrderByNullPrecedence orderByNullHandling() {
        return OrderByNullPrecedence.NONE;
    }
}

