/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BasicRelationalConverter
implements RelationalConverter {
    private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context;
    private final ConfigurableConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final CustomConversions conversions;

    public BasicRelationalConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context) {
        this(context, new CustomConversions(CustomConversions.StoreConversions.NONE, Collections.emptyList()), (ConfigurableConversionService)new DefaultConversionService(), new EntityInstantiators());
    }

    public BasicRelationalConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions) {
        this(context, conversions, (ConfigurableConversionService)new DefaultConversionService(), new EntityInstantiators());
    }

    private BasicRelationalConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, CustomConversions conversions, ConfigurableConversionService conversionService, EntityInstantiators entityInstantiators) {
        Assert.notNull(context, (String)"MappingContext must not be null");
        Assert.notNull((Object)conversions, (String)"CustomConversions must not be null");
        this.context = context;
        this.conversionService = conversionService;
        this.entityInstantiators = entityInstantiators;
        this.conversions = conversions;
        conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public CustomConversions getConversions() {
        return this.conversions;
    }

    @Override
    public MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> getMappingContext() {
        return this.context;
    }

    @Override
    public <T> PersistentPropertyPathAccessor<T> getPropertyAccessor(PersistentEntity<T, ?> persistentEntity, T instance) {
        PersistentPropertyPathAccessor accessor = persistentEntity.getPropertyPathAccessor(instance);
        return new ConvertingPropertyAccessor((PersistentPropertyAccessor)accessor, (ConversionService)this.conversionService);
    }

    @Override
    public <T> T createInstance(PersistentEntity<T, RelationalPersistentProperty> entity, Function<Parameter<?, RelationalPersistentProperty>, Object> parameterValueProvider) {
        return (T)this.entityInstantiators.getInstantiatorFor(entity).createInstance(entity, new ConvertingParameterValueProvider(parameterValueProvider));
    }

    @Override
    @Nullable
    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (null == value) {
            return null;
        }
        if (this.getConversions().hasCustomReadTarget(value.getClass(), type.getType())) {
            TypeDescriptor sourceDescriptor = TypeDescriptor.valueOf(value.getClass());
            TypeDescriptor targetDescriptor = BasicRelationalConverter.createTypeDescriptor(type);
            return this.getConversionService().convert(value, sourceDescriptor, targetDescriptor);
        }
        return this.getPotentiallyConvertedSimpleRead(value, type);
    }

    @Override
    @Nullable
    public Object writeValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        if (this.getConversions().isSimpleType(value.getClass())) {
            if (TypeInformation.OBJECT != type && this.conversionService.canConvert(value.getClass(), type.getType())) {
                value = this.conversionService.convert(value, type.getType());
            }
            return this.getPotentiallyConvertedSimpleWrite(value);
        }
        if (value.getClass().isArray() && !value.getClass().getComponentType().isEnum() && (TypeInformation.OBJECT.equals(type) || type.isCollectionLike())) {
            return value;
        }
        if (value instanceof Collection) {
            ArrayList<Object> mapped = new ArrayList<Object>();
            TypeInformation component = TypeInformation.OBJECT;
            if (type.isCollectionLike() && type.getActualType() != null) {
                component = type.getRequiredComponentType();
            }
            for (Object o : (Iterable)value) {
                mapped.add(this.writeValue(o, component));
            }
            if (type.getType().isInstance(mapped) || !type.isCollectionLike()) {
                return mapped;
            }
            return this.conversionService.convert(mapped, type.getType());
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(value.getClass());
        if (persistentEntity != null) {
            Object id = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            return this.writeValue(id, type);
        }
        return this.conversionService.convert(value, type.getType());
    }

    @Override
    public EntityInstantiators getEntityInstantiators() {
        return this.entityInstantiators;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.conversionService.convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleRead(Object value, TypeInformation<?> type) {
        Class target = type.getType();
        if (ClassUtils.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), BasicRelationalConverter.createTypeDescriptor(type));
    }

    private static TypeDescriptor createTypeDescriptor(TypeInformation<?> type) {
        List typeArguments = type.getTypeArguments();
        Class[] generics = new Class[typeArguments.size()];
        for (int i = 0; i < typeArguments.size(); ++i) {
            generics[i] = ((TypeInformation)typeArguments.get(i)).getType();
        }
        return new TypeDescriptor(ResolvableType.forClassWithGenerics((Class)type.getType(), (Class[])generics), type.getType(), null);
    }

    class ConvertingParameterValueProvider<P extends PersistentProperty<P>>
    implements ParameterValueProvider<P> {
        private final Function<Parameter<?, P>, Object> delegate;

        ConvertingParameterValueProvider(Function<Parameter<?, P>, Object> delegate) {
            Assert.notNull(delegate, (String)"Delegate must not be null");
            this.delegate = delegate;
        }

        public <T> T getParameterValue(Parameter<T, P> parameter) {
            return (T)BasicRelationalConverter.this.readValue(this.delegate.apply(parameter), parameter.getType());
        }
    }
}

