/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.conversion.PathNode;
import org.springframework.data.relational.core.conversion.RootAggregateChange;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class WritingContext<T> {
    private final RelationalMappingContext context;
    private final T root;
    private final Class<T> entityType;
    private final List<PersistentPropertyPath<RelationalPersistentProperty>> paths;
    private final Map<PathNode, DbAction<?>> previousActions = new HashMap();
    private final Map<PersistentPropertyPath<RelationalPersistentProperty>, List<PathNode>> nodesCache = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, List<PathNode>>();
    private final IdValueSource rootIdValueSource;
    @Nullable
    private final Number previousVersion;
    private final RootAggregateChange<T> aggregateChange;

    WritingContext(RelationalMappingContext context, T root, RootAggregateChange<T> aggregateChange) {
        this.context = context;
        this.root = root;
        this.entityType = aggregateChange.getEntityType();
        this.previousVersion = aggregateChange.getPreviousVersion();
        this.aggregateChange = aggregateChange;
        this.rootIdValueSource = IdValueSource.forInstance(root, (RelationalPersistentEntity)context.getRequiredPersistentEntity(aggregateChange.getEntityType()));
        this.paths = context.findPersistentPropertyPaths(this.entityType, p -> p.isEntity() && !p.isEmbedded()).filter(PersistentPropertyPathExtension::isWritable).toList();
    }

    void insert() {
        this.setRootAction(new DbAction.InsertRoot<T>(this.root, this.rootIdValueSource));
        this.insertReferenced().forEach(this.aggregateChange::addAction);
    }

    void update() {
        this.setRootAction(new DbAction.UpdateRoot<T>(this.root, this.previousVersion));
        this.deleteReferenced().forEach(this.aggregateChange::addAction);
        this.insertReferenced().forEach(this.aggregateChange::addAction);
    }

    void save() {
        if (this.isNew(this.root)) {
            this.setRootAction(new DbAction.InsertRoot<T>(this.root, this.rootIdValueSource));
            this.insertReferenced().forEach(this.aggregateChange::addAction);
        } else {
            this.setRootAction(new DbAction.UpdateRoot<T>(this.root, this.previousVersion));
            this.deleteReferenced().forEach(this.aggregateChange::addAction);
            this.insertReferenced().forEach(this.aggregateChange::addAction);
        }
    }

    private boolean isNew(Object o) {
        return ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(o.getClass())).isNew(o);
    }

    private List<DbAction<?>> insertReferenced() {
        ArrayList actions = new ArrayList();
        this.paths.forEach(path -> actions.addAll(this.insertAll((PersistentPropertyPath<RelationalPersistentProperty>)path)));
        return actions;
    }

    private List<? extends DbAction<?>> insertAll(PersistentPropertyPath<RelationalPersistentProperty> path) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity((RelationalPersistentProperty)path.getLeafProperty());
        ArrayList inserts = new ArrayList();
        this.from(path).forEach(node -> {
            Object instance;
            DbAction.WithEntity<?> parentAction = this.getAction(node.getParent());
            HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object>();
            if (((RelationalPersistentProperty)node.getPath().getLeafProperty()).isQualified()) {
                Pair value = (Pair)node.getValue();
                qualifiers.put(node.getPath(), value.getFirst());
                RelationalPersistentEntity parentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(parentAction.getEntityType());
                if (!parentEntity.hasIdProperty() && parentAction instanceof DbAction.Insert) {
                    qualifiers.putAll(((DbAction.Insert)parentAction).getQualifiers());
                }
                instance = value.getSecond();
            } else {
                instance = node.getValue();
            }
            IdValueSource idValueSource = IdValueSource.forInstance(instance, persistentEntity);
            DbAction.Insert<Object> insert = new DbAction.Insert<Object>(instance, path, parentAction, qualifiers, idValueSource);
            inserts.add(insert);
            this.previousActions.put((PathNode)node, (DbAction<?>)insert);
        });
        return inserts;
    }

    private List<DbAction<?>> deleteReferenced() {
        ArrayList deletes = new ArrayList();
        this.paths.forEach(path -> deletes.add(0, this.deleteReferenced((PersistentPropertyPath<RelationalPersistentProperty>)path)));
        return deletes;
    }

    private DbAction.Delete<?> deleteReferenced(PersistentPropertyPath<RelationalPersistentProperty> path) {
        Object id = ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(this.entityType)).getIdentifierAccessor(this.root).getIdentifier();
        return new DbAction.Delete(id, path);
    }

    private void setRootAction(DbAction.WithRoot<T> dbAction) {
        this.aggregateChange.setRootAction(dbAction);
        this.previousActions.put(null, dbAction);
    }

    @Nullable
    private DbAction.WithEntity<?> getAction(@Nullable PathNode parent) {
        DbAction<?> action = this.previousActions.get(parent);
        if (action != null) {
            Assert.isInstanceOf(DbAction.WithEntity.class, action, (String)("dependsOn action is not a WithEntity, but " + action.getClass().getSimpleName()));
            return (DbAction.WithEntity)action;
        }
        return null;
    }

    private List<PathNode> from(PersistentPropertyPath<RelationalPersistentProperty> path) {
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        if (this.isDirectlyReferencedByRootIgnoringEmbeddables(path)) {
            Object value = this.getFromRootValue(path);
            nodes.addAll(this.createNodes(path, null, value));
        } else {
            List<PathNode> pathNodes = this.nodesCache.getOrDefault(path.getParentPath(), Collections.emptyList());
            pathNodes.forEach(parentNode -> {
                Object parentValue = parentNode.getActualValue();
                Object value = ((RelationalPersistentProperty)path.getLeafProperty()).getOwner().getPropertyAccessor(parentValue).getProperty(path.getLeafProperty());
                nodes.addAll(this.createNodes(path, (PathNode)parentNode, value));
            });
        }
        this.nodesCache.put(path, nodes);
        return nodes;
    }

    private boolean isDirectlyReferencedByRootIgnoringEmbeddables(PersistentPropertyPath<RelationalPersistentProperty> path) {
        for (PersistentPropertyPath currentPath = path.getParentPath(); currentPath != null; currentPath = currentPath.getParentPath()) {
            if (((RelationalPersistentProperty)currentPath.getLeafProperty()).isEmbedded()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Object getFromRootValue(@Nullable PersistentPropertyPath<RelationalPersistentProperty> path) {
        if (path == null) {
            return this.root;
        }
        Object parent = this.getFromRootValue((PersistentPropertyPath<RelationalPersistentProperty>)path.getParentPath());
        if (parent == null) {
            return null;
        }
        return ((RelationalPersistentEntity)this.context.getRequiredPersistentEntity(parent.getClass())).getPropertyAccessor(parent).getProperty(path.getLeafProperty());
    }

    private List<PathNode> createNodes(PersistentPropertyPath<RelationalPersistentProperty> path, @Nullable PathNode parentNode, @Nullable Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        if (((RelationalPersistentProperty)path.getLeafProperty()).isEmbedded()) {
            nodes.add(new PathNode(path, parentNode, value));
        } else if (((RelationalPersistentProperty)path.getLeafProperty()).isQualified()) {
            if (((RelationalPersistentProperty)path.getLeafProperty()).isMap()) {
                ((Map)value).forEach((k, v) -> nodes.add(new PathNode(path, parentNode, Pair.of((Object)k, (Object)v))));
            } else {
                List listValue = (List)value;
                for (int k2 = 0; k2 < listValue.size(); ++k2) {
                    nodes.add(new PathNode(path, parentNode, Pair.of((Object)k2, listValue.get(k2))));
                }
            }
        } else if (((RelationalPersistentProperty)path.getLeafProperty()).isCollectionLike()) {
            if (value.getClass().isArray()) {
                Arrays.asList((Object[])value).forEach(v -> nodes.add(new PathNode(path, parentNode, v)));
            } else {
                ((Iterable)value).forEach(v -> nodes.add(new PathNode(path, parentNode, v)));
            }
        } else {
            nodes.add(new PathNode(path, parentNode, value));
        }
        return nodes;
    }
}

