/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface DbAction<T> {
    public Class<T> getEntityType();

    public static interface WithPropertyPath<T>
    extends DbAction<T> {
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath();

        @Override
        default public Class<T> getEntityType() {
            return ((RelationalPersistentProperty)this.getPropertyPath().getLeafProperty()).getActualType();
        }
    }

    public static interface WithRoot<T>
    extends WithEntity<T> {
        public void setEntity(T var1);
    }

    public static interface WithEntity<T>
    extends DbAction<T> {
        public T getEntity();

        @Override
        default public Class<T> getEntityType() {
            return this.getEntity().getClass();
        }

        public IdValueSource getIdValueSource();
    }

    public static interface WithDependingOn<T>
    extends WithPropertyPath<T>,
    WithEntity<T> {
        public WithEntity<?> getDependingOn();

        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers();

        @Nullable
        default public Pair<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifier() {
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = this.getQualifiers();
            if (qualifiers.size() == 0) {
                return null;
            }
            if (qualifiers.size() > 1) {
                throw new IllegalStateException("Can't handle more then one qualifier");
            }
            Map.Entry<PersistentPropertyPath<RelationalPersistentProperty>, Object> entry = qualifiers.entrySet().iterator().next();
            if (entry.getValue() == null) {
                return null;
            }
            return Pair.of(entry.getKey(), (Object)entry.getValue());
        }

        @Override
        default public Class<T> getEntityType() {
            return WithEntity.super.getEntityType();
        }
    }

    public static final class BatchDeleteRoot<T>
    extends BatchWithValue<T, DeleteRoot<T>, Class<T>> {
        BatchDeleteRoot(List<DeleteRoot<T>> actions) {
            super(actions, DeleteRoot::getEntityType);
        }
    }

    public static final class BatchDelete<T>
    extends BatchWithValue<T, Delete<T>, PersistentPropertyPath<RelationalPersistentProperty>> {
        public BatchDelete(List<Delete<T>> actions) {
            super(actions, Delete::getPropertyPath);
        }
    }

    public static final class BatchInsertRoot<T>
    extends BatchWithValue<T, InsertRoot<T>, IdValueSource> {
        public BatchInsertRoot(List<InsertRoot<T>> actions) {
            super(actions, InsertRoot::getIdValueSource);
        }
    }

    public static final class BatchInsert<T>
    extends BatchWithValue<T, Insert<T>, IdValueSource> {
        public BatchInsert(List<Insert<T>> actions) {
            super(actions, Insert::getIdValueSource);
        }
    }

    public static abstract class BatchWithValue<T, A extends DbAction<T>, B>
    implements DbAction<T> {
        private final List<A> actions;
        private final B batchValue;

        BatchWithValue(List<A> actions, Function<A, B> batchValueExtractor) {
            Assert.notEmpty(actions, (String)"Actions must contain at least one action");
            Iterator<A> actionIterator = actions.iterator();
            this.batchValue = batchValueExtractor.apply((DbAction)actionIterator.next());
            actionIterator.forEachRemaining(action -> Assert.isTrue((boolean)batchValueExtractor.apply(action).equals(this.batchValue), (String)"All actions in the batch must have matching batchValue"));
            this.actions = actions;
        }

        @Override
        public Class<T> getEntityType() {
            return ((DbAction)this.actions.get(0)).getEntityType();
        }

        public List<A> getActions() {
            return this.actions;
        }

        public B getBatchValue() {
            return this.batchValue;
        }

        public String toString() {
            return "BatchWithValue{actions=" + this.actions + ", batchValue=" + this.batchValue + "}";
        }
    }

    public static final class AcquireLockAllRoot<T>
    implements DbAction<T> {
        private final Class<T> entityType;

        AcquireLockAllRoot(Class<T> entityType) {
            this.entityType = entityType;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.AcquireLockAllRoot(entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class AcquireLockRoot<T>
    implements DbAction<T> {
        private final Object id;
        private final Class<T> entityType;

        AcquireLockRoot(Object id, Class<T> entityType) {
            this.id = id;
            this.entityType = entityType;
        }

        public Object getId() {
            return this.id;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.AcquireLockRoot(id=" + this.getId() + ", entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class DeleteAllRoot<T>
    implements DbAction<T> {
        private final Class<T> entityType;

        public DeleteAllRoot(Class<T> entityType) {
            this.entityType = entityType;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.DeleteAllRoot(entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class DeleteAll<T>
    implements WithPropertyPath<T> {
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        public DeleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            this.propertyPath = propertyPath;
        }

        @Override
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public String toString() {
            return "DbAction.DeleteAll(propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static final class DeleteRoot<T>
    implements DbAction<T> {
        private final Object id;
        private final Class<T> entityType;
        @Nullable
        private final Number previousVersion;

        public DeleteRoot(Object id, Class<T> entityType, @Nullable Number previousVersion) {
            this.id = id;
            this.entityType = entityType;
            this.previousVersion = previousVersion;
        }

        public Object getId() {
            return this.id;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        @Nullable
        public Number getPreviousVersion() {
            return this.previousVersion;
        }

        public String toString() {
            return "DbAction.DeleteRoot(id=" + this.getId() + ", entityType=" + this.getEntityType() + ", previousVersion=" + this.getPreviousVersion() + ")";
        }
    }

    public static final class Delete<T>
    implements WithPropertyPath<T> {
        private final Object rootId;
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        public Delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            this.rootId = rootId;
            this.propertyPath = propertyPath;
        }

        public Object getRootId() {
            return this.rootId;
        }

        @Override
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public String toString() {
            return "DbAction.Delete(rootId=" + this.getRootId() + ", propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static class UpdateRoot<T>
    implements WithRoot<T> {
        private T entity;
        @Nullable
        private final Number previousVersion;

        public UpdateRoot(T entity, @Nullable Number previousVersion) {
            this.entity = entity;
            this.previousVersion = previousVersion;
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        @Override
        public void setEntity(T entity) {
            this.entity = entity;
        }

        @Override
        public IdValueSource getIdValueSource() {
            return IdValueSource.PROVIDED;
        }

        @Nullable
        public Number getPreviousVersion() {
            return this.previousVersion;
        }

        public String toString() {
            return "DbAction.UpdateRoot(entity=" + this.getEntity() + ")";
        }
    }

    public static class InsertRoot<T>
    implements WithRoot<T> {
        private T entity;
        private final IdValueSource idValueSource;

        public InsertRoot(T entity, IdValueSource idValueSource) {
            this.entity = entity;
            this.idValueSource = idValueSource;
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        @Override
        public void setEntity(T entity) {
            this.entity = entity;
        }

        @Override
        public IdValueSource getIdValueSource() {
            return this.idValueSource;
        }

        public String toString() {
            return "InsertRoot{entity=" + this.entity + ", idValueSource=" + this.idValueSource + "}";
        }
    }

    public static class Insert<T>
    implements WithDependingOn<T> {
        private final T entity;
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;
        private final WithEntity<?> dependingOn;
        private final IdValueSource idValueSource;
        final Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers;

        public Insert(T entity, PersistentPropertyPath<RelationalPersistentProperty> propertyPath, WithEntity<?> dependingOn, Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers, IdValueSource idValueSource) {
            this.entity = entity;
            this.propertyPath = propertyPath;
            this.dependingOn = dependingOn;
            this.qualifiers = Map.copyOf(qualifiers);
            this.idValueSource = idValueSource;
        }

        @Override
        public Class<T> getEntityType() {
            return WithDependingOn.super.getEntityType();
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        @Override
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        public WithEntity<?> getDependingOn() {
            return this.dependingOn;
        }

        @Override
        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public IdValueSource getIdValueSource() {
            return this.idValueSource;
        }

        public String toString() {
            return "Insert{entity=" + this.entity + ", propertyPath=" + this.propertyPath + ", dependingOn=" + this.dependingOn + ", idValueSource=" + this.idValueSource + ", qualifiers=" + this.qualifiers + "}";
        }
    }
}

