/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.Arrays;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.OrderBy;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.SegmentList;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;

public class AnalyticFunction
extends AbstractSegment
implements Expression {
    private final SimpleFunction function;
    private final Partition partition;
    private final OrderBy orderBy;

    public static AnalyticFunction create(String function, Expression ... arguments) {
        return new AnalyticFunction(SimpleFunction.create(function, Arrays.asList(arguments)), new Partition(new Expression[0]), new OrderBy(new OrderByField[0]));
    }

    private AnalyticFunction(SimpleFunction function, Partition partition, OrderBy orderBy) {
        super(function, partition, orderBy);
        this.function = function;
        this.partition = partition;
        this.orderBy = orderBy;
    }

    public AnalyticFunction partitionBy(Expression ... partitionBy) {
        return new AnalyticFunction(this.function, new Partition(partitionBy), this.orderBy);
    }

    public AnalyticFunction orderBy(OrderByField ... orderBy) {
        return new AnalyticFunction(this.function, this.partition, new OrderBy(orderBy));
    }

    public AnalyticFunction orderBy(Expression ... orderByExpression) {
        OrderByField[] orderByFields = (OrderByField[])Arrays.stream(orderByExpression).map(OrderByField::from).toArray(OrderByField[]::new);
        return new AnalyticFunction(this.function, this.partition, new OrderBy(orderByFields));
    }

    public AliasedAnalyticFunction as(String alias) {
        return new AliasedAnalyticFunction(this, SqlIdentifier.unquoted(alias));
    }

    public AliasedAnalyticFunction as(SqlIdentifier alias) {
        return new AliasedAnalyticFunction(this, alias);
    }

    private static class AliasedAnalyticFunction
    extends AnalyticFunction
    implements Aliased {
        private final SqlIdentifier alias;

        AliasedAnalyticFunction(AnalyticFunction analyticFunction, SqlIdentifier alias) {
            super(analyticFunction.function, analyticFunction.partition, analyticFunction.orderBy);
            this.alias = alias;
        }

        @Override
        public SqlIdentifier getAlias() {
            return this.alias;
        }
    }

    public static class Partition
    extends SegmentList<Expression> {
        Partition(Expression ... expressions) {
            super((Segment[])expressions);
        }
    }
}

