/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.BindMarker;
import org.springframework.data.relational.core.sql.BooleanLiteral;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Literal;
import org.springframework.data.relational.core.sql.NumericLiteral;
import org.springframework.data.relational.core.sql.StringLiteral;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class SQL {
    public static Column column(String name, Table table) {
        return Column.create(name, table);
    }

    public static Table table(String name) {
        return Table.create(name);
    }

    public static BindMarker bindMarker() {
        return new BindMarker();
    }

    public static BindMarker bindMarker(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new BindMarker.NamedBindMarker(name);
    }

    public static BooleanLiteral literalOf(boolean value) {
        return new BooleanLiteral(value);
    }

    public static StringLiteral literalOf(@Nullable CharSequence content) {
        return new StringLiteral(content);
    }

    public static NumericLiteral literalOf(@Nullable Number content) {
        return new NumericLiteral(content);
    }

    public static <T> Literal<T> literalOf(@Nullable T content) {
        return new Literal<T>(content);
    }

    public static <T> Literal<T> nullLiteral() {
        return new Literal<Object>(null);
    }

    private SQL() {
    }
}

