/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class BatchStrategies {
    public static BatchStrategy keys() {
        return Keys.INSTANCE;
    }

    public static BatchStrategy scan(int batchSize) {
        Assert.isTrue((batchSize > 0 ? 1 : 0) != 0, (String)"Batch size must be greater than zero");
        return new Scan(batchSize);
    }

    private BatchStrategies() {
    }

    static class Keys
    implements BatchStrategy {
        static Keys INSTANCE = new Keys();

        Keys() {
        }

        @Override
        public long cleanCache(RedisConnection connection, String name, byte[] pattern) {
            RedisKeyCommands commands = connection.keyCommands();
            Set<byte[]> keys = commands.keys(pattern);
            if (CollectionUtils.isEmpty(keys)) {
                return 0L;
            }
            commands.del((byte[][])keys.toArray((T[])new byte[0][]));
            return keys.size();
        }
    }

    record Scan(int batchSize) implements BatchStrategy
    {
        @Override
        public long cleanCache(RedisConnection connection, String name, byte[] pattern) {
            RedisKeyCommands commands = connection.keyCommands();
            Cursor<byte[]> cursor = commands.scan(ScanOptions.scanOptions().count(this.batchSize).match(pattern).build());
            long count = 0L;
            PartitionIterator<byte[]> partitions = new PartitionIterator<byte[]>((Iterator<byte[]>)((Object)cursor), this.batchSize);
            while (partitions.hasNext()) {
                Object keys = partitions.next();
                count += (long)keys.size();
                if (keys.isEmpty()) continue;
                commands.del((byte[][])keys.toArray((T[])new byte[0][]));
            }
            return count;
        }
    }

    static class PartitionIterator<T>
    implements Iterator<List<T>> {
        private final Iterator<T> iterator;
        private final int size;

        PartitionIterator(Iterator<T> iterator, int size) {
            this.iterator = iterator;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public List<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ArrayList<T> list = new ArrayList<T>(this.size);
            while (list.size() < this.size && this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list;
        }
    }
}

