/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;

class DefaultRedisElementReader<T>
implements RedisElementReader<T> {
    private final @Nullable RedisSerializer<T> serializer;

    DefaultRedisElementReader(@Nullable RedisSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public @Nullable T read(ByteBuffer buffer) {
        if (this.serializer == null) {
            return (T)buffer;
        }
        return this.serializer.deserialize(ByteUtils.getBytes(buffer));
    }
}

