/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.Assert;

@NullUnmarked
public interface BoundValueOperations<K, V>
extends BoundKeyOperations<K> {
    public void set(@NonNull V var1);

    public void set(@NonNull V var1, long var2, @NonNull TimeUnit var4);

    public V setGet(@NonNull V var1, long var2, @NonNull TimeUnit var4);

    public V setGet(@NonNull V var1, @NonNull Duration var2);

    default public void set(@NonNull V value, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        if (TimeoutUtils.hasMillis(timeout)) {
            this.set(value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        } else {
            this.set(value, timeout.getSeconds(), TimeUnit.SECONDS);
        }
    }

    public Boolean setIfAbsent(@NonNull V var1);

    public Boolean setIfAbsent(@NonNull V var1, long var2, @NonNull TimeUnit var4);

    default public Boolean setIfAbsent(@NonNull V value, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfAbsent(value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfAbsent(value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public Boolean setIfPresent(@NonNull V var1);

    public Boolean setIfPresent(@NonNull V var1, long var2, @NonNull TimeUnit var4);

    default public Boolean setIfPresent(@NonNull V value, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        if (TimeoutUtils.hasMillis(timeout)) {
            return this.setIfPresent(value, timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return this.setIfPresent(value, timeout.getSeconds(), TimeUnit.SECONDS);
    }

    public V get();

    public V getAndDelete();

    public V getAndExpire(long var1, @NonNull TimeUnit var3);

    public V getAndExpire(@NonNull Duration var1);

    public V getAndPersist();

    public V getAndSet(@NonNull V var1);

    public Long increment();

    public Long increment(long var1);

    public Double increment(double var1);

    public Long decrement();

    public Long decrement(long var1);

    public Integer append(@NonNull String var1);

    public String get(long var1, long var3);

    public void set(@NonNull V var1, long var2);

    public Long size();

    @Override
    public @NonNull RedisOperations<K, V> getOperations();
}

