/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoSearch;
import io.lettuce.core.GeoWithin;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveGeoCommands
implements ReactiveGeoCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveGeoCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoAddCommand, Long>> geoAdd(Publisher<ReactiveGeoCommands.GeoAddCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getGeoLocations(), (String)"Locations must not be null");
            ArrayList<Double> values = new ArrayList<Double>();
            for (RedisGeoCommands.GeoLocation<ByteBuffer> location : command.getGeoLocations()) {
                Assert.notNull(location.getName(), (String)"Location.Name must not be null");
                Assert.notNull((Object)location.getPoint(), (String)"Location.Point must not be null");
                values.add(location.getPoint().getX());
                values.add(location.getPoint().getY());
                values.add((Double)location.getName());
            }
            return cmd.geoadd((Object)command.getKey(), values.toArray()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoAddCommand, Long>((ReactiveGeoCommands.GeoAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoDistCommand, Distance>> geoDist(Publisher<ReactiveGeoCommands.GeoDistCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getFrom(), (String)"From member must not be null");
            Assert.notNull((Object)command.getTo(), (String)"To member must not be null");
            RedisGeoCommands.DistanceUnit metric = command.getMetric().isPresent() ? command.getMetric().get() : RedisGeoCommands.DistanceUnit.METERS;
            GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(metric);
            Converter<Double, Distance> distanceConverter = LettuceConverters.distanceConverterForMetric(metric);
            Mono result = cmd.geodist((Object)command.getKey(), (Object)command.getFrom(), (Object)command.getTo(), geoUnit).map(arg_0 -> distanceConverter.convert(arg_0));
            return result.map(value -> new ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoDistCommand, Distance>((ReactiveGeoCommands.GeoDistCommand)command, (Distance)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveGeoCommands.GeoHashCommand, String>> geoHash(Publisher<ReactiveGeoCommands.GeoHashCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getMembers(), (String)"Members must not be null");
            return cmd.geohash((Object)command.getKey(), (Object[])((ByteBuffer[])command.getMembers().stream().toArray(ByteBuffer[]::new))).collectList().map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveGeoCommands.GeoHashCommand)command, value.stream().map(v -> (String)v.getValueOrElse(null)).collect(Collectors.toList())));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveGeoCommands.GeoPosCommand, Point>> geoPos(Publisher<ReactiveGeoCommands.GeoPosCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getMembers(), (String)"Members must not be null");
            Mono result = cmd.geopos((Object)command.getKey(), (Object[])((ByteBuffer[])command.getMembers().toArray(ByteBuffer[]::new))).collectList();
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveGeoCommands.GeoPosCommand)command, value.stream().map(v -> (GeoCoordinates)v.getValueOrElse(null)).map(LettuceConverters::geoCoordinatesToPoint).collect(Collectors.toList())));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadius(Publisher<ReactiveGeoCommands.GeoRadiusCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getPoint(), (String)"Point must not be null");
            Assert.notNull((Object)command.getDistance(), (String)"Distance must not be null");
            GeoArgs geoArgs = command.getArgs().isPresent() ? LettuceConverters.toGeoArgs(command.getArgs().get()) : new GeoArgs();
            Flux result = cmd.georadius((Object)command.getKey(), command.getPoint().getX(), command.getPoint().getY(), command.getDistance().getValue(), LettuceConverters.toGeoArgsUnit(command.getDistance().getMetric()), geoArgs).map(this.converter(command.getDistance().getMetric()));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusCommand, Flux>((ReactiveGeoCommands.GeoRadiusCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusByMemberCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoRadiusByMember(Publisher<ReactiveGeoCommands.GeoRadiusByMemberCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getMember(), (String)"Member must not be null");
            Assert.notNull((Object)command.getDistance(), (String)"Distance must not be null");
            GeoArgs geoArgs = command.getArgs().isPresent() ? LettuceConverters.toGeoArgs(command.getArgs().get()) : new GeoArgs();
            Flux result = cmd.georadiusbymember((Object)command.getKey(), (Object)command.getMember(), command.getDistance().getValue(), LettuceConverters.toGeoArgsUnit(command.getDistance().getMetric()), geoArgs).map(this.converter(command.getDistance().getMetric()));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoRadiusByMemberCommand, Flux>((ReactiveGeoCommands.GeoRadiusByMemberCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoSearchCommand, Flux<GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>>>> geoSearch(Publisher<ReactiveGeoCommands.GeoSearchCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getReference(), (String)"GeoReference must not be null");
            Assert.notNull((Object)command.getShape(), (String)"GeoShape must not be null");
            Assert.notNull(command.getArgs(), (String)"Command args must not be null");
            GeoArgs geoArgs = command.getArgs().map(LettuceConverters::toGeoArgs).orElseGet(GeoArgs::new);
            GeoSearch.GeoRef<ByteBuffer> ref = LettuceConverters.toGeoRef(command.getReference());
            GeoSearch.GeoPredicate predicate = LettuceConverters.toGeoPredicate(command.getShape());
            Flux result = cmd.geosearch((Object)command.getKey(), ref, predicate, geoArgs).map(this.converter(command.getShape().getMetric()));
            return new ReactiveRedisConnection.CommandResponse<ReactiveGeoCommands.GeoSearchCommand, Flux>((ReactiveGeoCommands.GeoSearchCommand)command, result);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoSearchStoreCommand, Long>> geoSearchStore(Publisher<ReactiveGeoCommands.GeoSearchStoreCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).flatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getDestKey(), (String)"Destination key must not be null");
            Assert.notNull(command.getReference(), (String)"GeoReference must not be null");
            Assert.notNull((Object)command.getShape(), (String)"GeoShape must not be null");
            Assert.notNull(command.getArgs(), (String)"Command args must not be null");
            GeoArgs geoArgs = command.getArgs().map(LettuceConverters::toGeoArgs).orElseGet(GeoArgs::new);
            Boolean storeDist = command.getArgs().map(RedisGeoCommands.GeoSearchStoreCommandArgs::isStoreDistance).orElse(false);
            GeoSearch.GeoRef<ByteBuffer> ref = LettuceConverters.toGeoRef(command.getReference());
            GeoSearch.GeoPredicate predicate = LettuceConverters.toGeoPredicate(command.getShape());
            Mono result = cmd.geosearchstore((Object)command.getDestKey(), (Object)command.getKey(), ref, predicate, geoArgs, storeDist.booleanValue());
            return result.map(it -> new ReactiveRedisConnection.NumericResponse<ReactiveGeoCommands.GeoSearchStoreCommand, Long>((ReactiveGeoCommands.GeoSearchStoreCommand)command, (Long)it));
        }));
    }

    private Function<GeoWithin<ByteBuffer>, GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>>> converter(Metric metric) {
        return source -> {
            Point point = LettuceConverters.geoCoordinatesToPoint(source.getCoordinates());
            return new GeoResult(new RedisGeoCommands.GeoLocation<ByteBuffer>((ByteBuffer)source.getMember(), point), new Distance(source.getDistance() != null ? source.getDistance() : 0.0, metric));
        };
    }
}

