/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.commands.StreamBinaryCommands;
import redis.clients.jedis.commands.StreamPipelineBinaryCommands;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.resps.StreamInfo;

@NullUnmarked
class JedisStreamCommands
implements RedisStreamCommands {
    private final JedisConnection connection;

    JedisStreamCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long xAck(byte @NonNull [] key, @NonNull String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.hasText((String)group, (String)"Group name must not be null or empty");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null");
        return this.connection.invoke().just(Jedis::xack, StreamPipelineBinaryCommands::xack, key, JedisConverters.toBytes(group), StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
    }

    @Override
    public RecordId xAdd(@NonNull MapRecord<byte[], byte[], byte[]> record, @NonNull RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record, (String)"Record must not be null");
        Assert.notNull(record.getStream(), (String)"Stream must not be null");
        XAddParams params = StreamConverters.toXAddParams(record.getId(), options);
        return (RecordId)this.connection.invoke().from(StreamBinaryCommands::xadd, StreamPipelineBinaryCommands::xadd, (byte[])record.getStream(), (Map)record.getValue(), params).get(it -> RecordId.of(JedisConverters.toString(it)));
    }

    @Override
    public List<@NonNull RecordId> xClaimJustId(byte @NonNull [] key, @NonNull String group, @NonNull String newOwner, @NonNull RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)group, (String)"Group must not be null");
        Assert.notNull((Object)newOwner, (String)"NewOwner must not be null");
        XClaimParams params = StreamConverters.toXClaimParams(options);
        return this.connection.invoke().fromMany(Jedis::xclaimJustId, StreamPipelineBinaryCommands::xclaimJustId, key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), options.getMinIdleTime().toMillis(), params, StreamConverters.entryIdsToBytes(options.getIds())).toList(it -> RecordId.of(JedisConverters.toString(it)));
    }

    @Override
    public List<@NonNull ByteRecord> xClaim(byte @NonNull [] key, @NonNull String group, @NonNull String newOwner, @NonNull RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)group, (String)"Group must not be null");
        Assert.notNull((Object)newOwner, (String)"NewOwner must not be null");
        XClaimParams params = StreamConverters.toXClaimParams(options);
        return (List)this.connection.invoke().from(Jedis::xclaim, StreamPipelineBinaryCommands::xclaim, key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), options.getMinIdleTime().toMillis(), params, StreamConverters.entryIdsToBytes(options.getIds())).get(r -> StreamConverters.convertToByteRecord(key, r));
    }

    @Override
    public Long xDel(byte @NonNull [] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null");
        return this.connection.invoke().just(Jedis::xdel, StreamPipelineBinaryCommands::xdel, key, StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
    }

    @Override
    public String xGroupCreate(byte @NonNull [] key, @NonNull String groupName, @NonNull ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    @Override
    public String xGroupCreate(byte @NonNull [] key, @NonNull String groupName, @NonNull ReadOffset readOffset, boolean mkStream) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty");
        Assert.notNull((Object)readOffset, (String)"ReadOffset must not be null");
        return this.connection.invoke().just(Jedis::xgroupCreate, StreamPipelineBinaryCommands::xgroupCreate, key, JedisConverters.toBytes(groupName), JedisConverters.toBytes(readOffset.getOffset()), mkStream);
    }

    @Override
    public Boolean xGroupDelConsumer(byte @NonNull [] key, @NonNull Consumer consumer) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)consumer, (String)"Consumer must not be null");
        return (Boolean)this.connection.invoke().from(Jedis::xgroupDelConsumer, StreamPipelineBinaryCommands::xgroupDelConsumer, key, JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName())).get(r -> r > 0L);
    }

    @Override
    public Boolean xGroupDestroy(byte @NonNull [] key, @NonNull String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty");
        return (Boolean)this.connection.invoke().from(Jedis::xgroupDestroy, StreamPipelineBinaryCommands::xgroupDestroy, key, JedisConverters.toBytes(groupName)).get(r -> r > 0L);
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (StreamInfo.XInfoStream)this.connection.invoke().from(Jedis::xinfoStream, StreamPipelineBinaryCommands::xinfoStream, key).get(it -> {
            StreamInfo streamInfo = (StreamInfo)BuilderFactory.STREAM_INFO.build(it);
            return StreamInfo.XInfoStream.fromList(StreamConverters.mapToList(streamInfo.getStreamInfo()));
        });
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (StreamInfo.XInfoGroups)this.connection.invoke().from(Jedis::xinfoGroups, StreamPipelineBinaryCommands::xinfoGroups, key).get(it -> {
            List streamGroupInfos = (List)BuilderFactory.STREAM_GROUP_INFO_LIST.build(it);
            ArrayList<Object> sources = new ArrayList<Object>();
            streamGroupInfos.forEach(streamGroupInfo -> sources.add(StreamConverters.mapToList(streamGroupInfo.getGroupInfo())));
            return StreamInfo.XInfoGroups.fromList(sources);
        });
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte @NonNull [] key, @NonNull String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty");
        return (StreamInfo.XInfoConsumers)this.connection.invoke().from(Jedis::xinfoConsumers, StreamPipelineBinaryCommands::xinfoConsumers, key, JedisConverters.toBytes(groupName)).get(it -> {
            List streamConsumersInfos = (List)BuilderFactory.STREAM_CONSUMER_INFO_LIST.build(it);
            ArrayList<Object> sources = new ArrayList<Object>();
            streamConsumersInfos.forEach(streamConsumersInfo -> sources.add(StreamConverters.mapToList(streamConsumersInfo.getConsumerInfo())));
            return StreamInfo.XInfoConsumers.fromList(groupName, sources);
        });
    }

    @Override
    public Long xLen(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::xlen, StreamPipelineBinaryCommands::xlen, key);
    }

    @Override
    public PendingMessagesSummary xPending(byte @NonNull [] key, @NonNull String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (PendingMessagesSummary)this.connection.invoke().from(Jedis::xpending, StreamPipelineBinaryCommands::xpending, key, JedisConverters.toBytes(groupName)).get(it -> StreamConverters.toPendingMessagesSummary(groupName, it));
    }

    @Override
    public PendingMessages xPending(byte @NonNull [] key, @NonNull String groupName, @NonNull RedisStreamCommands.XPendingOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)groupName, (String)"GroupName must not be null");
        Range<?> range = options.getRange();
        XPendingParams xPendingParams = StreamConverters.toXPendingParams(options);
        return (PendingMessages)this.connection.invoke().from(Jedis::xpending, StreamPipelineBinaryCommands::xpending, key, JedisConverters.toBytes(groupName), xPendingParams).get(r -> StreamConverters.toPendingMessages(groupName, range, (List)BuilderFactory.STREAM_PENDING_ENTRY_LIST.build(r)));
    }

    @Override
    public List<@NonNull ByteRecord> xRange(byte @NonNull [] key, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        return (List)this.connection.invoke().from(Jedis::xrange, StreamPipelineBinaryCommands::xrange, key, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), count).get(r -> StreamConverters.convertToByteRecord(key, r));
    }

    @Override
    public List<@NonNull ByteRecord> xRead(@NonNull StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null");
        Assert.notNull(streams, (String)"StreamOffsets must not be null");
        XReadParams params = StreamConverters.toXReadParams(readOptions);
        return this.connection.invoke().from(Jedis::xread, StreamPipelineBinaryCommands::xread, params, StreamConverters.toStreamOffsets(streams)).getOrElse(StreamConverters::convertToByteRecords, Collections::emptyList);
    }

    @Override
    public List<@NonNull ByteRecord> xReadGroup(@NonNull Consumer consumer, @NonNull StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, (String)"Consumer must not be null");
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null");
        Assert.notNull(streams, (String)"StreamOffsets must not be null");
        XReadGroupParams params = StreamConverters.toXReadGroupParams(readOptions);
        return this.connection.invoke().from(Jedis::xreadGroup, StreamPipelineBinaryCommands::xreadGroup, JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName()), params, StreamConverters.toStreamOffsets(streams)).getOrElse(StreamConverters::convertToByteRecords, Collections::emptyList);
    }

    @Override
    public List<@NonNull ByteRecord> xRevRange(byte @NonNull [] key, @NonNull Range<String> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        return (List)this.connection.invoke().from(Jedis::xrevrange, StreamPipelineBinaryCommands::xrevrange, key, JedisConverters.toBytes(StreamConverters.getUpperValue(range)), JedisConverters.toBytes(StreamConverters.getLowerValue(range)), count).get(it -> StreamConverters.convertToByteRecord(key, it));
    }

    @Override
    public Long xTrim(byte @NonNull [] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte @NonNull [] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::xtrim, StreamPipelineBinaryCommands::xtrim, key, count, approximateTrimming);
    }
}

