/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.SentinelMasterId;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisSentinelConfiguration
implements RedisConfiguration,
RedisConfiguration.SentinelConfiguration {
    private static final String REDIS_SENTINEL_MASTER_CONFIG_PROPERTY = "spring.redis.sentinel.master";
    private static final String REDIS_SENTINEL_NODES_CONFIG_PROPERTY = "spring.redis.sentinel.nodes";
    private static final String REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY = "spring.redis.sentinel.username";
    private static final String REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY = "spring.redis.sentinel.password";
    private static final String REDIS_SENTINEL_DATA_NODE_USERNAME_CONFIG_PROPERTY = "spring.redis.sentinel.dataNode.username";
    private static final String REDIS_SENTINEL_DATA_NODE_PASSWORD_CONFIG_PROPERTY = "spring.redis.sentinel.dataNode.password";
    private static final String REDIS_SENTINEL_DATA_NODE_DATABASE_CONFIG_PROPERTY = "spring.redis.sentinel.dataNode.database";
    private int database;
    private @Nullable NamedNode master;
    private RedisPassword dataNodePassword = RedisPassword.none();
    private RedisPassword sentinelPassword = RedisPassword.none();
    private final Set<RedisNode> sentinels = new LinkedHashSet<RedisNode>();
    private @Nullable String dataNodeUsername = null;
    private @Nullable String sentinelUsername = null;

    public RedisSentinelConfiguration() {
    }

    public RedisSentinelConfiguration(String master, Set<String> sentinelHostAndPorts) {
        Assert.notNull((Object)master, (String)"Sentinel master must not be null");
        Assert.notNull(sentinelHostAndPorts, (String)"Sentinel nodes must not be null");
        this.master = new SentinelMasterId(master);
        for (String hostAndPort : sentinelHostAndPorts) {
            this.addSentinel(RedisNode.fromString(hostAndPort, 26379));
        }
    }

    public static RedisSentinelConfiguration of(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null");
        RedisSentinelConfiguration configuration = new RedisSentinelConfiguration();
        if (propertySource.containsProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY)) {
            String sentinelMaster = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY));
            configuration.setMaster(sentinelMaster);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY)) {
            String sentinelNodes = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_NODES_CONFIG_PROPERTY));
            configuration.appendSentinels(StringUtils.commaDelimitedListToSet((String)sentinelNodes));
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY)) {
            String sentinelPassword = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_PASSWORD_CONFIG_PROPERTY));
            configuration.setSentinelPassword(sentinelPassword);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY)) {
            String sentinelUsername = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_USERNAME_CONFIG_PROPERTY));
            configuration.setSentinelUsername(sentinelUsername);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_DATA_NODE_USERNAME_CONFIG_PROPERTY)) {
            String dataNodeUsername = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_DATA_NODE_USERNAME_CONFIG_PROPERTY));
            configuration.setUsername(dataNodeUsername);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_DATA_NODE_PASSWORD_CONFIG_PROPERTY)) {
            String dataNodePassword = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_DATA_NODE_PASSWORD_CONFIG_PROPERTY));
            configuration.setPassword(dataNodePassword);
        }
        if (propertySource.containsProperty(REDIS_SENTINEL_DATA_NODE_DATABASE_CONFIG_PROPERTY)) {
            int database;
            String databaseSource = String.valueOf(propertySource.getProperty(REDIS_SENTINEL_DATA_NODE_DATABASE_CONFIG_PROPERTY));
            try {
                database = Integer.parseInt(databaseSource);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid DB index '%s'; integer required".formatted(databaseSource));
            }
            configuration.setDatabase(database);
        }
        return configuration;
    }

    public void setSentinels(Iterable<RedisNode> sentinels) {
        Assert.notNull(sentinels, (String)"Cannot set sentinels to null");
        this.sentinels.clear();
        for (RedisNode sentinel : sentinels) {
            this.addSentinel(sentinel);
        }
    }

    @Override
    public Set<RedisNode> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void addSentinel(RedisNode sentinel) {
        Assert.notNull((Object)sentinel, (String)"Sentinel must not be null");
        this.sentinels.add(sentinel);
    }

    @Override
    public void setMaster(NamedNode master) {
        Assert.notNull((Object)master, (String)"Sentinel master node must not be null");
        this.master = master;
    }

    @Override
    public @Nullable NamedNode getMaster() {
        return this.master;
    }

    public RedisSentinelConfiguration master(String master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration master(NamedNode master) {
        this.setMaster(master);
        return this;
    }

    public RedisSentinelConfiguration sentinel(RedisNode sentinel) {
        this.addSentinel(sentinel);
        return this;
    }

    public RedisSentinelConfiguration sentinel(String host, Integer port) {
        return this.sentinel(new RedisNode(host, port));
    }

    private void appendSentinels(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addSentinel(RedisNode.fromString(hostAndPort, 26379));
        }
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Invalid DB index '%d'; non-negative index required".formatted(index));
        this.database = index;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.dataNodeUsername = username;
    }

    @Override
    public @Nullable String getUsername() {
        return this.dataNodeUsername;
    }

    @Override
    public RedisPassword getPassword() {
        return this.dataNodePassword;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null");
        this.dataNodePassword = password;
    }

    @Override
    public @Nullable String getSentinelUsername() {
        return this.sentinelUsername;
    }

    @Override
    public void setSentinelUsername(@Nullable String sentinelUsername) {
        this.sentinelUsername = sentinelUsername;
    }

    @Override
    public void setSentinelPassword(RedisPassword sentinelPassword) {
        Assert.notNull((Object)sentinelPassword, (String)"SentinelPassword must not be null");
        this.sentinelPassword = sentinelPassword;
    }

    @Override
    public RedisPassword getSentinelPassword() {
        return this.sentinelPassword;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RedisSentinelConfiguration)) {
            return false;
        }
        RedisSentinelConfiguration that = (RedisSentinelConfiguration)obj;
        return this.database == that.database && ObjectUtils.nullSafeEquals((Object)this.master, (Object)that.master) && ObjectUtils.nullSafeEquals(this.sentinels, that.sentinels) && ObjectUtils.nullSafeEquals((Object)this.dataNodeUsername, (Object)that.dataNodeUsername) && ObjectUtils.nullSafeEquals((Object)this.dataNodePassword, (Object)that.dataNodePassword) && ObjectUtils.nullSafeEquals((Object)this.sentinelUsername, (Object)that.sentinelUsername) && ObjectUtils.nullSafeEquals((Object)this.sentinelPassword, (Object)that.sentinelPassword);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.master);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sentinels);
        result = 31 * result + this.database;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.dataNodeUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.dataNodePassword);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sentinelUsername);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.sentinelPassword);
        return result;
    }

    private static Map<String, Object> asMap(String master, Set<String> sentinelHostAndPorts) {
        Assert.hasText((String)master, (String)"Master address must not be null or empty");
        Assert.notNull(sentinelHostAndPorts, (String)"SentinelHostAndPorts must not be null");
        Assert.noNullElements(sentinelHostAndPorts, (String)"ClusterHostAndPorts must not contain null elements");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_SENTINEL_MASTER_CONFIG_PROPERTY, master);
        map.put(REDIS_SENTINEL_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(sentinelHostAndPorts));
        return map;
    }
}

