/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import reactor.core.publisher.Mono;

public interface RedisCredentialsProviderFactory {
    default public @Nullable RedisCredentialsProvider createCredentialsProvider(RedisConfiguration redisConfiguration) {
        RedisConfiguration.WithAuthentication withAuthentication;
        if (redisConfiguration instanceof RedisConfiguration.WithAuthentication && (withAuthentication = (RedisConfiguration.WithAuthentication)((Object)redisConfiguration)).getPassword().isPresent()) {
            return RedisCredentialsProvider.from(() -> RedisCredentials.just((String)withAuthentication.getUsername(), (char[])withAuthentication.getPassword().get()));
        }
        return () -> Mono.just((Object)((Object)AbsentRedisCredentials.ANONYMOUS));
    }

    default public RedisCredentialsProvider createSentinelCredentialsProvider(RedisSentinelConfiguration redisConfiguration) {
        if (redisConfiguration.getSentinelPassword().isPresent()) {
            return RedisCredentialsProvider.from(() -> RedisCredentials.just((String)redisConfiguration.getSentinelUsername(), (char[])redisConfiguration.getSentinelPassword().get()));
        }
        return () -> Mono.just((Object)((Object)AbsentRedisCredentials.ANONYMOUS));
    }

    public static enum AbsentRedisCredentials implements RedisCredentials
    {
        ANONYMOUS;


        public @Nullable String getUsername() {
            return null;
        }

        public boolean hasUsername() {
            return false;
        }

        public char @Nullable [] getPassword() {
            return null;
        }

        public boolean hasPassword() {
            return false;
        }
    }
}

