/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoSearch;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.api.async.RedisGeoAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.util.Assert;

@NullUnmarked
class LettuceGeoCommands
implements RedisGeoCommands {
    private final LettuceConnection connection;

    LettuceGeoCommands(@NonNull LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long geoAdd(byte @NonNull [] key, @NonNull Point point, byte @NonNull [] member) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)point, (String)"Point must not be null");
        Assert.notNull((Object)member, (String)"Member must not be null");
        return (Long)this.connection.invoke().just(RedisGeoAsyncCommands::geoadd, key, point.getX(), point.getY(), member);
    }

    @Override
    public Long geoAdd(byte @NonNull [] key, @NonNull Map<byte @NonNull [], @NonNull Point> memberCoordinateMap) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null");
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<byte[], Point> entry : memberCoordinateMap.entrySet()) {
            values.add(entry.getValue().getX());
            values.add(entry.getValue().getY());
            values.add(entry.getKey());
        }
        return this.geoAdd(key, (Collection<Object>)values);
    }

    @Override
    public Long geoAdd(byte @NonNull [] key, @NonNull Iterable<@NonNull RedisGeoCommands.GeoLocation<byte[]>> locations) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(locations, (String)"Locations must not be null");
        ArrayList<Object> values = new ArrayList<Object>();
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            values.add(location.getPoint().getX());
            values.add(location.getPoint().getY());
            values.add(location.getName());
        }
        return this.geoAdd(key, (Collection<Object>)values);
    }

    private @Nullable Long geoAdd(byte @NonNull [] key, @NonNull Collection<@NonNull Object> values) {
        return (Long)this.connection.invoke().just(it -> it.geoadd((Object)key, values.toArray()));
    }

    @Override
    public Distance geoDist(byte @NonNull [] key, byte @NonNull [] member1, byte @NonNull [] member2) {
        return this.geoDist(key, member1, member2, RedisGeoCommands.DistanceUnit.METERS);
    }

    @Override
    public Distance geoDist(byte @NonNull [] key, byte @NonNull [] member1, byte @NonNull [] member2, @NonNull Metric metric) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)member1, (String)"Member1 must not be null");
        Assert.notNull((Object)member2, (String)"Member2 must not be null");
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(metric);
        Converter<Double, Distance> distanceConverter = LettuceConverters.distanceConverterForMetric(metric);
        return this.connection.invoke().from(RedisGeoAsyncCommands::geodist, key, member1, member2, geoUnit).get(distanceConverter);
    }

    @Override
    public List<String> geoHash(byte @NonNull [] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)members, (String)"Members must not be null");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null");
        return this.connection.invoke().fromMany(RedisGeoAsyncCommands::geohash, key, members).toList(it -> (String)it.getValueOrElse(null));
    }

    @Override
    public List<Point> geoPos(byte @NonNull [] key, byte[] ... members) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)members, (String)"Members must not be null");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null");
        return this.connection.invoke().fromMany(RedisGeoAsyncCommands::geopos, key, members).toList(LettuceConverters::geoCoordinatesToPoint);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte @NonNull [] key, @NonNull Circle within) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)within, (String)"Within must not be null");
        Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.bytesSetToGeoResultsConverter();
        return this.connection.invoke().from(it -> it.georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()))).get(geoResultsConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte @NonNull [] key, @NonNull Circle within, @NonNull RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)within, (String)"Within must not be null");
        Assert.notNull((Object)args, (String)"Args must not be null");
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.geoRadiusResponseToGeoResultsConverter(within.getRadius().getMetric());
        return this.connection.invoke().from(it -> it.georadius((Object)key, within.getCenter().getX(), within.getCenter().getY(), within.getRadius().getValue(), LettuceConverters.toGeoArgsUnit(within.getRadius().getMetric()), geoArgs)).get(geoResultsConverter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte @NonNull [] key, byte @NonNull [] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte @NonNull [] key, byte @NonNull [] member, @NonNull Distance radius) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)member, (String)"Member must not be null");
        Assert.notNull((Object)radius, (String)"Radius must not be null");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(radius.getMetric());
        Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> converter = LettuceConverters.bytesSetToGeoResultsConverter();
        return this.connection.invoke().from(RedisGeoAsyncCommands::georadiusbymember, key, member, radius.getValue(), geoUnit).get(converter);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte @NonNull [] key, byte @NonNull [] member, @NonNull Distance radius, @NonNull RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)member, (String)"Member must not be null");
        Assert.notNull((Object)radius, (String)"Radius must not be null");
        Assert.notNull((Object)args, (String)"Args must not be null");
        GeoArgs.Unit geoUnit = LettuceConverters.toGeoArgsUnit(radius.getMetric());
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoResultsConverter = LettuceConverters.geoRadiusResponseToGeoResultsConverter(radius.getMetric());
        return this.connection.invoke().from(RedisGeoAsyncCommands::georadiusbymember, key, member, radius.getValue(), geoUnit, geoArgs).get(geoResultsConverter);
    }

    @Override
    public Long geoRemove(byte @NonNull [] key, byte[] ... values) {
        return this.connection.zSetCommands().zRem(key, values);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoSearch(byte @NonNull [] key, @NonNull GeoReference<byte[]> reference, @NonNull GeoShape predicate, @NonNull RedisGeoCommands.GeoSearchCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(reference, (String)"Reference must not be null");
        Assert.notNull((Object)predicate, (String)"GeoPredicate must not be null");
        Assert.notNull((Object)args, (String)"GeoSearchCommandArgs must not be null");
        GeoSearch.GeoRef<byte[]> ref = LettuceConverters.toGeoRef(reference);
        GeoSearch.GeoPredicate lettucePredicate = LettuceConverters.toGeoPredicate(predicate);
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        return this.connection.invoke().from(RedisGeoAsyncCommands::geosearch, key, ref, lettucePredicate, geoArgs).get(LettuceConverters.geoRadiusResponseToGeoResultsConverter(predicate.getMetric()));
    }

    @Override
    public Long geoSearchStore(byte @NonNull [] destKey, byte @NonNull [] key, @NonNull GeoReference<byte[]> reference, @NonNull GeoShape predicate, @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(reference, (String)"Reference must not be null");
        Assert.notNull((Object)predicate, (String)"GeoPredicate must not be null");
        Assert.notNull((Object)args, (String)"GeoSearchCommandArgs must not be null");
        GeoSearch.GeoRef<byte[]> ref = LettuceConverters.toGeoRef(reference);
        GeoSearch.GeoPredicate lettucePredicate = LettuceConverters.toGeoPredicate(predicate);
        GeoArgs geoArgs = LettuceConverters.toGeoArgs(args);
        return (Long)this.connection.invoke().just(connection -> connection.geosearchstore((Object)destKey, (Object)key, ref, lettucePredicate, geoArgs, args.isStoreDistance()));
    }
}

