/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.commands.KeyBinaryCommands;
import redis.clients.jedis.commands.KeyPipelineBinaryCommands;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.SortingParams;
import redis.clients.jedis.resps.ScanResult;

@NullUnmarked
class JedisKeyCommands
implements RedisKeyCommands {
    private final JedisConnection connection;

    JedisKeyCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean exists(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::exists, KeyPipelineBinaryCommands::exists, key);
    }

    @Override
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(KeyBinaryCommands::exists, KeyPipelineBinaryCommands::exists, keys);
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(KeyBinaryCommands::del, KeyPipelineBinaryCommands::del, keys);
    }

    @Override
    public Boolean copy(byte @NonNull [] sourceKey, byte @NonNull [] targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, (String)"source key must not be null");
        Assert.notNull((Object)targetKey, (String)"target key must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::copy, KeyPipelineBinaryCommands::copy, sourceKey, targetKey, replace);
    }

    @Override
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::unlink, KeyPipelineBinaryCommands::unlink, keys);
    }

    @Override
    public DataType type(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(KeyBinaryCommands::type, KeyPipelineBinaryCommands::type, key).get(JedisConverters.stringToDataType());
    }

    @Override
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::touch, KeyPipelineBinaryCommands::touch, keys);
    }

    @Override
    public Set<byte @NonNull []> keys(byte @NonNull [] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::keys, KeyPipelineBinaryCommands::keys, pattern);
    }

    @Override
    public Cursor<byte @NonNull []> scan(@NonNull ScanOptions options) {
        return this.scan(Cursor.CursorId.initial(), options != null ? options : ScanOptions.NONE);
    }

    public Cursor<byte @NonNull []> scan(@NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
        return new ScanCursor<byte[]>(cursorId, options){

            @Override
            protected ScanIteration<byte[]> doScan(Cursor.CursorId cursorId, ScanOptions options) {
                String typeAsString;
                if (JedisKeyCommands.this.isQueueing() || JedisKeyCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'SCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                byte[] type = null;
                if (options instanceof KeyScanOptions && !ObjectUtils.isEmpty((Object)(typeAsString = ((KeyScanOptions)options).getType()))) {
                    type = typeAsString.getBytes(StandardCharsets.US_ASCII);
                }
                ScanResult result = type != null ? JedisKeyCommands.this.connection.getJedis().scan(JedisConverters.toBytes(cursorId), params, type) : JedisKeyCommands.this.connection.getJedis().scan(JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<byte[]>(Cursor.CursorId.of(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisKeyCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public byte[] randomKey() {
        return this.connection.invoke().just(KeyBinaryCommands::randomBinaryKey, KeyPipelineBinaryCommands::randomBinaryKey);
    }

    @Override
    public void rename(byte @NonNull [] oldKey, byte @NonNull [] newKey) {
        Assert.notNull((Object)oldKey, (String)"Old key must not be null");
        Assert.notNull((Object)newKey, (String)"New key must not be null");
        this.connection.invokeStatus().just(KeyBinaryCommands::rename, KeyPipelineBinaryCommands::rename, oldKey, newKey);
    }

    @Override
    public Boolean renameNX(byte @NonNull [] sourceKey, byte @NonNull [] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null");
        return this.connection.invoke().from(KeyBinaryCommands::renamenx, KeyPipelineBinaryCommands::renamenx, sourceKey, targetKey).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean expire(byte @NonNull [] key, long seconds, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (seconds > Integer.MAX_VALUE) {
            return this.pExpire(key, TimeUnit.SECONDS.toMillis(seconds), condition);
        }
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().from(KeyBinaryCommands::expire, KeyPipelineBinaryCommands::expire, key, seconds).get(JedisConverters.longToBoolean());
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().from(KeyBinaryCommands::expire, KeyPipelineBinaryCommands::expire, key, seconds, option).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean pExpire(byte @NonNull [] key, long millis, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().from(KeyBinaryCommands::pexpire, KeyPipelineBinaryCommands::pexpire, key, millis).get(JedisConverters.longToBoolean());
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().from(KeyBinaryCommands::pexpire, KeyPipelineBinaryCommands::pexpire, key, millis, option).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean expireAt(byte @NonNull [] key, long unixTime, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().from(KeyBinaryCommands::expireAt, KeyPipelineBinaryCommands::expireAt, key, unixTime).get(JedisConverters.longToBoolean());
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().from(KeyBinaryCommands::expireAt, KeyPipelineBinaryCommands::expireAt, key, unixTime, option).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean pExpireAt(byte @NonNull [] key, long unixTimeInMillis, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().from(KeyBinaryCommands::pexpireAt, KeyPipelineBinaryCommands::pexpireAt, key, unixTimeInMillis).get(JedisConverters.longToBoolean());
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().from(KeyBinaryCommands::pexpireAt, KeyPipelineBinaryCommands::pexpireAt, key, unixTimeInMillis, option).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean persist(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(KeyBinaryCommands::persist, KeyPipelineBinaryCommands::persist, key).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean move(byte @NonNull [] key, int dbIndex) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(j -> j.move(key, dbIndex)).get(JedisConverters.longToBoolean());
    }

    @Override
    public Long ttl(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::ttl, KeyPipelineBinaryCommands::ttl, key);
    }

    @Override
    public Long ttl(byte @NonNull [] key, @NonNull TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(KeyBinaryCommands::ttl, KeyPipelineBinaryCommands::ttl, key).get(Converters.secondsToTimeUnit(timeUnit));
    }

    @Override
    public Long pTtl(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::pttl, KeyPipelineBinaryCommands::pttl, key);
    }

    @Override
    public Long pTtl(byte @NonNull [] key, @NonNull TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(KeyBinaryCommands::pttl, KeyPipelineBinaryCommands::pttl, key).get(Converters.millisecondsToTimeUnit(timeUnit));
    }

    @Override
    public List<byte @NonNull []> sort(byte @NonNull [] key, @Nullable SortParameters params) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        if (sortParams != null) {
            return this.connection.invoke().just(KeyBinaryCommands::sort, KeyPipelineBinaryCommands::sort, key, sortParams);
        }
        return this.connection.invoke().just(KeyBinaryCommands::sort, KeyPipelineBinaryCommands::sort, key);
    }

    @Override
    public Long sort(byte @NonNull [] key, @Nullable SortParameters params, byte @NonNull [] storeKey) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        SortingParams sortParams = JedisConverters.toSortingParams(params);
        if (sortParams != null) {
            return this.connection.invoke().just(KeyBinaryCommands::sort, KeyPipelineBinaryCommands::sort, key, sortParams, storeKey);
        }
        return this.connection.invoke().just(KeyBinaryCommands::sort, KeyPipelineBinaryCommands::sort, key, storeKey);
    }

    @Override
    public byte[] dump(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::dump, KeyPipelineBinaryCommands::dump, key);
    }

    @Override
    public void restore(byte @NonNull [] key, long ttlInMillis, byte @NonNull [] serializedValue, boolean replace) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)serializedValue, (String)"Serialized value must not be null");
        if (replace) {
            this.connection.invokeStatus().just(KeyBinaryCommands::restore, KeyPipelineBinaryCommands::restore, key, (int)ttlInMillis, serializedValue, RestoreParams.restoreParams().replace());
            return;
        }
        if (ttlInMillis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("TtlInMillis must be less than Integer.MAX_VALUE for restore in Jedis");
        }
        this.connection.invokeStatus().just(KeyBinaryCommands::restore, KeyPipelineBinaryCommands::restore, key, (int)ttlInMillis, serializedValue);
    }

    @Override
    public ValueEncoding encodingOf(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(KeyBinaryCommands::objectEncoding, KeyPipelineBinaryCommands::objectEncoding, key).getOrElse(JedisConverters::toEncoding, () -> ValueEncoding.RedisValueEncoding.VACANT);
    }

    @Override
    public Duration idletime(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Duration)this.connection.invoke().from(KeyBinaryCommands::objectIdletime, KeyPipelineBinaryCommands::objectIdletime, key).get(Converters::secondsToDuration);
    }

    @Override
    public Long refcount(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(KeyBinaryCommands::objectRefcount, KeyPipelineBinaryCommands::objectRefcount, key);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

