/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.core.types.Expiration;

@NullUnmarked
public interface RedisStringCommands {
    public byte[] get(byte @NonNull [] var1);

    public byte[] getDel(byte @NonNull [] var1);

    public byte[] getEx(byte @NonNull [] var1, @NonNull Expiration var2);

    public byte[] getSet(byte @NonNull [] var1, byte @NonNull [] var2);

    public List<byte[]> mGet(byte[] ... var1);

    public Boolean set(byte @NonNull [] var1, byte @NonNull [] var2);

    public Boolean set(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull Expiration var3, @NonNull SetOption var4);

    public byte[] setGet(byte @NonNull [] var1, byte @NonNull [] var2, @NonNull Expiration var3, @NonNull SetOption var4);

    public Boolean setNX(byte @NonNull [] var1, byte @NonNull [] var2);

    public Boolean setEx(byte @NonNull [] var1, long var2, byte @NonNull [] var4);

    public Boolean pSetEx(byte @NonNull [] var1, long var2, byte @NonNull [] var4);

    public Boolean mSet(@NonNull Map<byte @NonNull [], byte @NonNull []> var1);

    public Boolean mSetNX(@NonNull Map<byte @NonNull [], byte @NonNull []> var1);

    public Long incr(byte @NonNull [] var1);

    public Long incrBy(byte @NonNull [] var1, long var2);

    public Double incrBy(byte @NonNull [] var1, double var2);

    public Long decr(byte @NonNull [] var1);

    public Long decrBy(byte @NonNull [] var1, long var2);

    public Long append(byte @NonNull [] var1, byte[] var2);

    public byte[] getRange(byte @NonNull [] var1, long var2, long var4);

    public void setRange(byte @NonNull [] var1, byte @NonNull [] var2, long var3);

    public Boolean getBit(byte @NonNull [] var1, long var2);

    public Boolean setBit(byte @NonNull [] var1, long var2, boolean var4);

    public Long bitCount(byte @NonNull [] var1);

    public Long bitCount(byte @NonNull [] var1, long var2, long var4);

    public List<Long> bitField(byte @NonNull [] var1, @NonNull BitFieldSubCommands var2);

    public Long bitOp(@NonNull BitOperation var1, byte @NonNull [] var2, byte[] ... var3);

    default public Long bitPos(byte @NonNull [] key, boolean bit) {
        return this.bitPos(key, bit, (Range<Long>)Range.unbounded());
    }

    public Long bitPos(byte @NonNull [] var1, boolean var2, @NonNull Range<@NonNull Long> var3);

    public Long strLen(byte @NonNull [] var1);

    public static enum SetOption {
        UPSERT,
        SET_IF_ABSENT,
        SET_IF_PRESENT;


        public static SetOption upsert() {
            return UPSERT;
        }

        public static SetOption ifPresent() {
            return SET_IF_PRESENT;
        }

        public static SetOption ifAbsent() {
            return SET_IF_ABSENT;
        }
    }

    public static enum BitOperation {
        AND,
        OR,
        XOR,
        NOT;

    }
}

