/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisClusterConfiguration
implements RedisConfiguration,
RedisConfiguration.ClusterConfiguration {
    private static final String REDIS_CLUSTER_NODES_CONFIG_PROPERTY = "spring.redis.cluster.nodes";
    private static final String REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY = "spring.redis.cluster.max-redirects";
    private @Nullable Integer maxRedirects;
    private RedisPassword password = RedisPassword.none();
    private final Set<RedisNode> clusterNodes = new LinkedHashSet<RedisNode>();
    private @Nullable String username = null;

    public RedisClusterConfiguration() {
    }

    public RedisClusterConfiguration(Collection<String> clusterNodes) {
        for (String hostAndPort : clusterNodes) {
            this.addClusterNode(RedisNode.fromString(hostAndPort));
        }
    }

    public static RedisClusterConfiguration of(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null");
        RedisClusterConfiguration configuration = new RedisClusterConfiguration();
        if (propertySource.containsProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY)) {
            Object redisClusterNodes = propertySource.getProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY);
            configuration.appendClusterNodes(StringUtils.commaDelimitedListToSet((String)String.valueOf(redisClusterNodes)));
        }
        if (propertySource.containsProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY)) {
            Object clusterMaxRedirects = propertySource.getProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY);
            configuration.setMaxRedirects((Integer)NumberUtils.parseNumber((String)String.valueOf(clusterMaxRedirects), Integer.class));
        }
        return configuration;
    }

    private void appendClusterNodes(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addClusterNode(RedisNode.fromString(hostAndPort));
        }
    }

    public void setClusterNodes(Iterable<RedisNode> nodes) {
        Assert.notNull(nodes, (String)"Cannot set cluster nodes to null");
        this.clusterNodes.clear();
        for (RedisNode clusterNode : nodes) {
            this.addClusterNode(clusterNode);
        }
    }

    @Override
    public Set<RedisNode> getClusterNodes() {
        return Collections.unmodifiableSet(this.clusterNodes);
    }

    public void addClusterNode(RedisNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be null");
        this.clusterNodes.add(node);
    }

    public RedisClusterConfiguration clusterNode(String host, Integer port) {
        return this.clusterNode(new RedisNode(host, port));
    }

    public RedisClusterConfiguration clusterNode(RedisNode node) {
        this.clusterNodes.add(node);
        return this;
    }

    public void setMaxRedirects(int maxRedirects) {
        Assert.isTrue((maxRedirects >= 0 ? 1 : 0) != 0, (String)"MaxRedirects must be greater or equal to 0");
        this.maxRedirects = maxRedirects;
    }

    @Override
    public @Nullable Integer getMaxRedirects() {
        return this.maxRedirects != null && this.maxRedirects > Integer.MIN_VALUE ? this.maxRedirects : null;
    }

    @Override
    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Override
    public @Nullable String getUsername() {
        return this.username;
    }

    @Override
    public void setPassword(RedisPassword password) {
        Assert.notNull((Object)password, (String)"RedisPassword must not be null");
        this.password = password;
    }

    @Override
    public RedisPassword getPassword() {
        return this.password;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RedisClusterConfiguration)) {
            return false;
        }
        RedisClusterConfiguration that = (RedisClusterConfiguration)obj;
        return ObjectUtils.nullSafeEquals(this.clusterNodes, that.clusterNodes) && ObjectUtils.nullSafeEquals((Object)this.maxRedirects, (Object)that.maxRedirects) && ObjectUtils.nullSafeEquals((Object)this.username, (Object)that.username) && ObjectUtils.nullSafeEquals((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.clusterNodes);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.maxRedirects);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.username);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.password);
        return result;
    }
}

