/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum DataType {
    NONE("none"),
    STRING("string"),
    LIST("list"),
    SET("set"),
    ZSET("zset"),
    HASH("hash"),
    STREAM("stream");

    private static final Map<String, DataType> codeLookup;
    private final String code;

    private DataType(String name) {
        this.code = name;
    }

    public String code() {
        return this.code;
    }

    public static DataType fromCode(String code) {
        DataType data = codeLookup.get(code);
        if (data == null) {
            throw new IllegalArgumentException("unknown data type code %s".formatted(code));
        }
        return data;
    }

    static {
        codeLookup = new ConcurrentHashMap<String, DataType>(7);
        for (DataType type : EnumSet.allOf(DataType.class)) {
            codeLookup.put(type.code, type);
        }
    }
}

