/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.connection.stream.StringRecord;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public interface StringRedisConnection
extends RedisConnection {
    public Object execute(String var1, String ... var2);

    public Object execute(String var1);

    public Boolean exists(String var1);

    @Nullable
    public Long exists(String ... var1);

    public Long del(String ... var1);

    public Boolean copy(String var1, String var2, boolean var3);

    @Nullable
    public Long unlink(String ... var1);

    public DataType type(String var1);

    @Nullable
    public Long touch(String ... var1);

    public Collection<String> keys(String var1);

    public void rename(String var1, String var2);

    public Boolean renameNX(String var1, String var2);

    default public Boolean expire(String key, long seconds) {
        return this.expire(key, seconds, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean expire(String var1, long var2, ExpirationOptions.Condition var4);

    default public Boolean pExpire(String key, long millis) {
        return this.pExpire(key, millis, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean pExpire(String var1, long var2, ExpirationOptions.Condition var4);

    default public Boolean expireAt(String key, long unixTime) {
        return this.expireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean expireAt(String var1, long var2, ExpirationOptions.Condition var4);

    default public Boolean pExpireAt(String key, long unixTimeInMillis) {
        return this.pExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS);
    }

    public Boolean pExpireAt(String var1, long var2, ExpirationOptions.Condition var4);

    public Boolean persist(String var1);

    public Boolean move(String var1, int var2);

    public Long ttl(String var1);

    public Long ttl(String var1, TimeUnit var2);

    public Long pTtl(String var1);

    public Long pTtl(String var1, TimeUnit var2);

    public String echo(String var1);

    public List<String> sort(String var1, SortParameters var2);

    public Long sort(String var1, SortParameters var2, String var3);

    @Nullable
    public ValueEncoding encodingOf(String var1);

    @Nullable
    public Duration idletime(String var1);

    @Nullable
    public Long refcount(String var1);

    public String get(String var1);

    @Nullable
    public String getDel(String var1);

    @Nullable
    public String getEx(String var1, Expiration var2);

    public String getSet(String var1, String var2);

    public List<String> mGet(String ... var1);

    @Nullable
    public Boolean set(String var1, String var2);

    @Nullable
    public Boolean set(String var1, String var2, Expiration var3, RedisStringCommands.SetOption var4);

    @Nullable
    public Boolean setNX(String var1, String var2);

    @Nullable
    public Boolean setEx(String var1, long var2, String var4);

    @Nullable
    public Boolean pSetEx(String var1, long var2, String var4);

    @Nullable
    public Boolean mSetString(Map<String, String> var1);

    public Boolean mSetNXString(Map<String, String> var1);

    public Long incr(String var1);

    public Long incrBy(String var1, long var2);

    public Double incrBy(String var1, double var2);

    public Long decr(String var1);

    public Long decrBy(String var1, long var2);

    public Long append(String var1, String var2);

    public String getRange(String var1, long var2, long var4);

    public void setRange(String var1, String var2, long var3);

    public Boolean getBit(String var1, long var2);

    public Boolean setBit(String var1, long var2, boolean var4);

    public Long bitCount(String var1);

    public Long bitCount(String var1, long var2, long var4);

    public Long bitOp(RedisStringCommands.BitOperation var1, String var2, String ... var3);

    default public Long bitPos(String key, boolean bit) {
        return this.bitPos(key, bit, (Range<Long>)Range.unbounded());
    }

    @Nullable
    public Long bitPos(String var1, boolean var2, Range<Long> var3);

    public Long strLen(String var1);

    public Long rPush(String var1, String ... var2);

    @Nullable
    default public Long lPos(String key, String element) {
        return (Long)CollectionUtils.firstElement(this.lPos(key, element, null, null));
    }

    public List<Long> lPos(String var1, String var2, @Nullable Integer var3, @Nullable Integer var4);

    public Long lPush(String var1, String ... var2);

    public Long rPushX(String var1, String var2);

    public Long lPushX(String var1, String var2);

    public Long lLen(String var1);

    public List<String> lRange(String var1, long var2, long var4);

    public void lTrim(String var1, long var2, long var4);

    public String lIndex(String var1, long var2);

    public Long lInsert(String var1, RedisListCommands.Position var2, String var3, String var4);

    @Nullable
    public String lMove(String var1, String var2, RedisListCommands.Direction var3, RedisListCommands.Direction var4);

    @Nullable
    public String bLMove(String var1, String var2, RedisListCommands.Direction var3, RedisListCommands.Direction var4, double var5);

    public void lSet(String var1, long var2, String var4);

    public Long lRem(String var1, long var2, String var4);

    public String lPop(String var1);

    public List<String> lPop(String var1, long var2);

    public String rPop(String var1);

    public List<String> rPop(String var1, long var2);

    public List<String> bLPop(int var1, String ... var2);

    public List<String> bRPop(int var1, String ... var2);

    public String rPopLPush(String var1, String var2);

    public String bRPopLPush(int var1, String var2, String var3);

    public Long sAdd(String var1, String ... var2);

    public Long sRem(String var1, String ... var2);

    public String sPop(String var1);

    public List<String> sPop(String var1, long var2);

    public Boolean sMove(String var1, String var2, String var3);

    public Long sCard(String var1);

    public Boolean sIsMember(String var1, String var2);

    @Nullable
    public List<Boolean> sMIsMember(String var1, String ... var2);

    public Set<String> sInter(String ... var1);

    public Long sInterStore(String var1, String ... var2);

    public Set<String> sUnion(String ... var1);

    public Long sUnionStore(String var1, String ... var2);

    public Set<String> sDiff(String ... var1);

    public Long sDiffStore(String var1, String ... var2);

    public Set<String> sMembers(String var1);

    public String sRandMember(String var1);

    public List<String> sRandMember(String var1, long var2);

    public Cursor<String> sScan(String var1, ScanOptions var2);

    public Boolean zAdd(String var1, double var2, String var4);

    public Boolean zAdd(String var1, double var2, String var4, RedisZSetCommands.ZAddArgs var5);

    public Long zAdd(String var1, Set<StringTuple> var2);

    @Nullable
    public Long zAdd(String var1, Set<StringTuple> var2, RedisZSetCommands.ZAddArgs var3);

    public Long zRem(String var1, String ... var2);

    public Double zIncrBy(String var1, double var2, String var4);

    @Nullable
    public String zRandMember(String var1);

    @Nullable
    public List<String> zRandMember(String var1, long var2);

    @Nullable
    public StringTuple zRandMemberWithScore(String var1);

    @Nullable
    public List<StringTuple> zRandMemberWithScores(String var1, long var2);

    public Long zRank(String var1, String var2);

    public Long zRevRank(String var1, String var2);

    public Set<String> zRange(String var1, long var2, long var4);

    public Set<StringTuple> zRangeWithScores(String var1, long var2, long var4);

    public Set<String> zRangeByScore(String var1, double var2, double var4);

    public Set<StringTuple> zRangeByScoreWithScores(String var1, double var2, double var4);

    public Set<String> zRangeByScore(String var1, double var2, double var4, long var6, long var8);

    public Set<StringTuple> zRangeByScoreWithScores(String var1, double var2, double var4, long var6, long var8);

    public Set<String> zRevRange(String var1, long var2, long var4);

    public Set<StringTuple> zRevRangeWithScores(String var1, long var2, long var4);

    public Set<String> zRevRangeByScore(String var1, double var2, double var4);

    public Set<StringTuple> zRevRangeByScoreWithScores(String var1, double var2, double var4);

    public Set<String> zRevRangeByScore(String var1, double var2, double var4, long var6, long var8);

    public Set<StringTuple> zRevRangeByScoreWithScores(String var1, double var2, double var4, long var6, long var8);

    public Long zCount(String var1, double var2, double var4);

    @Nullable
    public Long zLexCount(String var1, Range<String> var2);

    @Nullable
    public Tuple zPopMin(String var1);

    @Nullable
    public Set<StringTuple> zPopMin(String var1, long var2);

    @Nullable
    public StringTuple bZPopMin(String var1, long var2, TimeUnit var4);

    @Nullable
    public StringTuple zPopMax(String var1);

    @Nullable
    public Set<StringTuple> zPopMax(String var1, long var2);

    @Nullable
    public StringTuple bZPopMax(String var1, long var2, TimeUnit var4);

    public Long zCard(String var1);

    public Double zScore(String var1, String var2);

    public List<Double> zMScore(String var1, String ... var2);

    public Long zRemRange(String var1, long var2, long var4);

    public Long zRemRangeByLex(String var1, Range<String> var2);

    public Long zRemRangeByScore(String var1, double var2, double var4);

    @Nullable
    public Set<String> zDiff(String ... var1);

    @Nullable
    public Set<StringTuple> zDiffWithScores(String ... var1);

    @Nullable
    public Long zDiffStore(String var1, String ... var2);

    @Nullable
    public Set<String> zInter(String ... var1);

    @Nullable
    public Set<StringTuple> zInterWithScores(String ... var1);

    @Nullable
    default public Set<StringTuple> zInterWithScores(Aggregate aggregate, int[] weights, String ... sets) {
        return this.zInterWithScores(aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Set<StringTuple> zInterWithScores(Aggregate var1, Weights var2, String ... var3);

    public Long zInterStore(String var1, String ... var2);

    public Long zInterStore(String var1, Aggregate var2, int[] var3, String ... var4);

    @Nullable
    public Set<String> zUnion(String ... var1);

    @Nullable
    public Set<StringTuple> zUnionWithScores(String ... var1);

    @Nullable
    default public Set<StringTuple> zUnionWithScores(Aggregate aggregate, int[] weights, String ... sets) {
        return this.zUnionWithScores(aggregate, Weights.of(weights), sets);
    }

    @Nullable
    public Set<StringTuple> zUnionWithScores(Aggregate var1, Weights var2, String ... var3);

    public Long zUnionStore(String var1, String ... var2);

    public Long zUnionStore(String var1, Aggregate var2, int[] var3, String ... var4);

    public Cursor<StringTuple> zScan(String var1, ScanOptions var2);

    public Set<String> zRangeByScore(String var1, String var2, String var3);

    public Set<String> zRangeByScore(String var1, String var2, String var3, long var4, long var6);

    public Set<String> zRangeByLex(String var1);

    public Set<String> zRangeByLex(String var1, Range<String> var2);

    public Set<String> zRangeByLex(String var1, Range<String> var2, Limit var3);

    default public Set<String> zRevRangeByLex(String key) {
        return this.zRevRangeByLex(key, (Range<String>)Range.unbounded());
    }

    default public Set<String> zRevRangeByLex(String key, Range<String> range) {
        return this.zRevRangeByLex(key, range, Limit.unlimited());
    }

    public Set<String> zRevRangeByLex(String var1, Range<String> var2, Limit var3);

    @Nullable
    default public Long zRangeStoreByLex(String dstKey, String srcKey, Range<String> range) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreByLex(String var1, String var2, Range<String> var3, Limit var4);

    @Nullable
    default public Long zRangeStoreRevByLex(String dstKey, String srcKey, Range<String> range) {
        return this.zRangeStoreRevByLex(dstKey, srcKey, range, Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreRevByLex(String var1, String var2, Range<String> var3, Limit var4);

    @Nullable
    default public Long zRangeStoreByScore(String dstKey, String srcKey, Range<? extends Number> range) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreByScore(String var1, String var2, Range<? extends Number> var3, Limit var4);

    @Nullable
    default public Long zRangeStoreRevByScore(String dstKey, String srcKey, Range<? extends Number> range) {
        return this.zRangeStoreRevByScore(dstKey, srcKey, range, Limit.unlimited());
    }

    @Nullable
    public Long zRangeStoreRevByScore(String var1, String var2, Range<? extends Number> var3, Limit var4);

    public Boolean hSet(String var1, String var2, String var3);

    public Boolean hSetNX(String var1, String var2, String var3);

    public String hGet(String var1, String var2);

    public List<String> hMGet(String var1, String ... var2);

    public void hMSet(String var1, Map<String, String> var2);

    public Long hIncrBy(String var1, String var2, long var3);

    public Double hIncrBy(String var1, String var2, double var3);

    @Nullable
    public String hRandField(String var1);

    @Nullable
    public Map.Entry<String, String> hRandFieldWithValues(String var1);

    @Nullable
    public List<String> hRandField(String var1, long var2);

    @Nullable
    public List<Map.Entry<String, String>> hRandFieldWithValues(String var1, long var2);

    public Boolean hExists(String var1, String var2);

    public Long hDel(String var1, String ... var2);

    public Long hLen(String var1);

    public Set<String> hKeys(String var1);

    public List<String> hVals(String var1);

    public Map<String, String> hGetAll(String var1);

    public Cursor<Map.Entry<String, String>> hScan(String var1, ScanOptions var2);

    @Nullable
    public Long hStrLen(String var1, String var2);

    @Nullable
    default public List<Long> hExpire(String key, long seconds, String ... fields) {
        return this.hExpire(key, seconds, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    public List<Long> hExpire(String var1, long var2, ExpirationOptions.Condition var4, String ... var5);

    @Nullable
    default public List<Long> hpExpire(String key, long millis, String ... fields) {
        return this.hpExpire(key, millis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    public List<Long> hpExpire(String var1, long var2, ExpirationOptions.Condition var4, String ... var5);

    @Nullable
    default public List<Long> hExpireAt(String key, long unixTime, String ... fields) {
        return this.hExpireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    public List<Long> hExpireAt(String var1, long var2, ExpirationOptions.Condition var4, String ... var5);

    @Nullable
    default public List<Long> hpExpireAt(String key, long unixTimeInMillis, String ... fields) {
        return this.hpExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    public List<Long> hpExpireAt(String var1, long var2, ExpirationOptions.Condition var4, String ... var5);

    @Nullable
    public List<Long> hPersist(String var1, String ... var2);

    @Nullable
    public List<Long> hTtl(String var1, String ... var2);

    @Nullable
    public List<Long> hTtl(String var1, TimeUnit var2, String ... var3);

    @Nullable
    public List<Long> hpTtl(String var1, String ... var2);

    public Long pfAdd(String var1, String ... var2);

    public Long pfCount(String ... var1);

    public void pfMerge(String var1, String ... var2);

    public Long geoAdd(String var1, Point var2, String var3);

    public Long geoAdd(String var1, RedisGeoCommands.GeoLocation<String> var2);

    public Long geoAdd(String var1, Map<String, Point> var2);

    public Long geoAdd(String var1, Iterable<RedisGeoCommands.GeoLocation<String>> var2);

    public Distance geoDist(String var1, String var2, String var3);

    public Distance geoDist(String var1, String var2, String var3, Metric var4);

    public List<String> geoHash(String var1, String ... var2);

    public List<Point> geoPos(String var1, String ... var2);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String var1, Circle var2);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadius(String var1, Circle var2, RedisGeoCommands.GeoRadiusCommandArgs var3);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(String var1, String var2, double var3);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(String var1, String var2, Distance var3);

    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoRadiusByMember(String var1, String var2, Distance var3, RedisGeoCommands.GeoRadiusCommandArgs var4);

    public Long geoRemove(String var1, String ... var2);

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<String>> geoSearch(String var1, GeoReference<String> var2, GeoShape var3, RedisGeoCommands.GeoSearchCommandArgs var4);

    @Nullable
    public Long geoSearchStore(String var1, String var2, GeoReference<String> var3, GeoShape var4, RedisGeoCommands.GeoSearchStoreCommandArgs var5);

    public Long publish(String var1, String var2);

    public void subscribe(MessageListener var1, String ... var2);

    public void pSubscribe(MessageListener var1, String ... var2);

    public String scriptLoad(String var1);

    public <T> T eval(String var1, ReturnType var2, int var3, String ... var4);

    public <T> T evalSha(String var1, ReturnType var2, int var3, String ... var4);

    public void setClientName(String var1);

    @Override
    public List<RedisClientInfo> getClientList();

    public List<Long> bitfield(String var1, BitFieldSubCommands var2);

    public static RecordId[] entryIds(String ... entryIds) {
        if (entryIds.length == 1) {
            return new RecordId[]{RecordId.of(entryIds[0])};
        }
        return (RecordId[])Arrays.stream(entryIds).map(RecordId::of).toArray(RecordId[]::new);
    }

    @Nullable
    default public Long xAck(String key, String group, String ... entryIds) {
        return this.xAck(key, group, StringRedisConnection.entryIds(entryIds));
    }

    public Long xAck(String var1, String var2, RecordId ... var3);

    @Nullable
    default public RecordId xAdd(String key, Map<String, String> body) {
        return this.xAdd(StreamRecords.newRecord().in(key).ofStrings(body));
    }

    @Nullable
    default public RecordId xAdd(StringRecord record) {
        return this.xAdd(record, RedisStreamCommands.XAddOptions.none());
    }

    @Nullable
    public RecordId xAdd(StringRecord var1, RedisStreamCommands.XAddOptions var2);

    public List<RecordId> xClaimJustId(String var1, String var2, String var3, RedisStreamCommands.XClaimOptions var4);

    default public List<StringRecord> xClaim(String key, String group, String newOwner, Duration minIdleTime, RecordId ... recordIds) {
        return this.xClaim(key, group, newOwner, RedisStreamCommands.XClaimOptions.minIdle(minIdleTime).ids(recordIds));
    }

    public List<StringRecord> xClaim(String var1, String var2, String var3, RedisStreamCommands.XClaimOptions var4);

    @Nullable
    default public Long xDel(String key, String ... entryIds) {
        return this.xDel(key, StringRedisConnection.entryIds(entryIds));
    }

    public Long xDel(String var1, RecordId ... var2);

    @Nullable
    public String xGroupCreate(String var1, ReadOffset var2, String var3);

    @Nullable
    public String xGroupCreate(String var1, ReadOffset var2, String var3, boolean var4);

    @Nullable
    public Boolean xGroupDelConsumer(String var1, Consumer var2);

    @Nullable
    public Boolean xGroupDestroy(String var1, String var2);

    @Nullable
    public StreamInfo.XInfoStream xInfo(String var1);

    @Nullable
    public StreamInfo.XInfoGroups xInfoGroups(String var1);

    @Nullable
    public StreamInfo.XInfoConsumers xInfoConsumers(String var1, String var2);

    @Nullable
    public Long xLen(String var1);

    @Nullable
    public PendingMessagesSummary xPending(String var1, String var2);

    @Nullable
    public PendingMessages xPending(String var1, String var2, String var3, Range<String> var4, Long var5);

    @Nullable
    public PendingMessages xPending(String var1, String var2, Range<String> var3, Long var4);

    @Nullable
    public PendingMessages xPending(String var1, String var2, RedisStreamCommands.XPendingOptions var3);

    @Nullable
    default public List<StringRecord> xRange(String key, Range<String> range) {
        return this.xRange(key, range, Limit.unlimited());
    }

    @Nullable
    public List<StringRecord> xRange(String var1, Range<String> var2, Limit var3);

    @Nullable
    default public List<StringRecord> xReadAsString(StreamOffset<String> stream) {
        return this.xReadAsString(StreamReadOptions.empty(), new StreamOffset[]{stream});
    }

    @Nullable
    default public List<StringRecord> xReadAsString(StreamOffset<String> ... streams) {
        return this.xReadAsString(StreamReadOptions.empty(), streams);
    }

    @Nullable
    default public List<StringRecord> xReadAsString(StreamReadOptions readOptions, StreamOffset<String> stream) {
        return this.xReadAsString(readOptions, new StreamOffset[]{stream});
    }

    @Nullable
    public List<StringRecord> xReadAsString(StreamReadOptions var1, StreamOffset<String> ... var2);

    @Nullable
    default public List<StringRecord> xReadGroupAsString(Consumer consumer, StreamOffset<String> stream) {
        return this.xReadGroupAsString(consumer, StreamReadOptions.empty(), new StreamOffset[]{stream});
    }

    @Nullable
    default public List<StringRecord> xReadGroupAsString(Consumer consumer, StreamOffset<String> ... streams) {
        return this.xReadGroupAsString(consumer, StreamReadOptions.empty(), streams);
    }

    @Nullable
    default public List<StringRecord> xReadGroupAsString(Consumer consumer, StreamReadOptions readOptions, StreamOffset<String> stream) {
        return this.xReadGroupAsString(consumer, readOptions, new StreamOffset[]{stream});
    }

    @Nullable
    public List<StringRecord> xReadGroupAsString(Consumer var1, StreamReadOptions var2, StreamOffset<String> ... var3);

    @Nullable
    default public List<StringRecord> xRevRange(String key, Range<String> range) {
        return this.xRevRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<StringRecord> xRevRange(String var1, Range<String> var2, Limit var3);

    @Nullable
    public Long xTrim(String var1, long var2);

    @Nullable
    public Long xTrim(String var1, long var2, boolean var4);

    public static interface StringTuple
    extends Tuple {
        public String getValueAsString();
    }
}

