/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveZSetOperations<K, V> {
    public Mono<Boolean> add(K var1, V var2, double var3);

    public Mono<Long> addAll(K var1, Collection<? extends ZSetOperations.TypedTuple<V>> var2);

    public Mono<Long> remove(K var1, Object ... var2);

    public Mono<Double> incrementScore(K var1, V var2, double var3);

    public Mono<V> randomMember(K var1);

    public Flux<V> distinctRandomMembers(K var1, long var2);

    public Flux<V> randomMembers(K var1, long var2);

    public Mono<ZSetOperations.TypedTuple<V>> randomMemberWithScore(K var1);

    public Flux<ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(K var1, long var2);

    public Flux<ZSetOperations.TypedTuple<V>> randomMembersWithScore(K var1, long var2);

    public Mono<Long> rank(K var1, Object var2);

    public Mono<Long> reverseRank(K var1, Object var2);

    public Flux<V> range(K var1, Range<Long> var2);

    public Flux<ZSetOperations.TypedTuple<V>> rangeWithScores(K var1, Range<Long> var2);

    public Flux<V> rangeByScore(K var1, Range<Double> var2);

    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K var1, Range<Double> var2);

    public Flux<V> rangeByScore(K var1, Range<Double> var2, Limit var3);

    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(K var1, Range<Double> var2, Limit var3);

    public Flux<V> reverseRange(K var1, Range<Long> var2);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(K var1, Range<Long> var2);

    public Flux<V> reverseRangeByScore(K var1, Range<Double> var2);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K var1, Range<Double> var2);

    public Flux<V> reverseRangeByScore(K var1, Range<Double> var2, Limit var3);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(K var1, Range<Double> var2, Limit var3);

    default public Mono<Long> rangeAndStoreByLex(K srcKey, K dstKey, Range<String> range) {
        return this.rangeAndStoreByLex(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> rangeAndStoreByLex(K var1, K var2, Range<String> var3, Limit var4);

    default public Mono<Long> reverseRangeAndStoreByLex(K srcKey, K dstKey, Range<String> range) {
        return this.reverseRangeAndStoreByLex(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> reverseRangeAndStoreByLex(K var1, K var2, Range<String> var3, Limit var4);

    @Nullable
    default public Mono<Long> rangeAndStoreByScore(K srcKey, K dstKey, Range<Double> range) {
        return this.rangeAndStoreByScore(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> rangeAndStoreByScore(K var1, K var2, Range<Double> var3, Limit var4);

    default public Mono<Long> reverseRangeAndStoreByScore(K srcKey, K dstKey, Range<Double> range) {
        return this.reverseRangeAndStoreByScore(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> reverseRangeAndStoreByScore(K var1, K var2, Range<Double> var3, Limit var4);

    default public Flux<ZSetOperations.TypedTuple<V>> scan(K key) {
        return this.scan(key, ScanOptions.NONE);
    }

    public Flux<ZSetOperations.TypedTuple<V>> scan(K var1, ScanOptions var2);

    public Mono<Long> count(K var1, Range<Double> var2);

    public Mono<Long> lexCount(K var1, Range<String> var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMin(K var1);

    public Flux<ZSetOperations.TypedTuple<V>> popMin(K var1, long var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMin(K var1, Duration var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMax(K var1);

    public Flux<ZSetOperations.TypedTuple<V>> popMax(K var1, long var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMax(K var1, Duration var2);

    public Mono<Long> size(K var1);

    public Mono<Double> score(K var1, Object var2);

    public Mono<List<Double>> score(K var1, Object ... var2);

    public Mono<Long> removeRange(K var1, Range<Long> var2);

    public Mono<Long> removeRangeByLex(K var1, Range<String> var2);

    public Mono<Long> removeRangeByScore(K var1, Range<Double> var2);

    default public Flux<V> difference(K key, K otherKey) {
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<V> difference(K var1, Collection<K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> differenceWithScores(K key, K otherKey) {
        return this.differenceWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<ZSetOperations.TypedTuple<V>> differenceWithScores(K var1, Collection<K> var2);

    default public Mono<Long> differenceAndStore(K key, K otherKey, K destKey) {
        return this.differenceAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public Mono<Long> differenceAndStore(K var1, Collection<K> var2, K var3);

    default public Flux<V> intersect(K key, K otherKey) {
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<V> intersect(K var1, Collection<K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K key, K otherKey) {
        return this.intersectWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K var1, Collection<K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K key, Collection<K> otherKeys, Aggregate aggregate) {
        return this.intersectWithScores(key, otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(K var1, Collection<K> var2, Aggregate var3, Weights var4);

    default public Mono<Long> intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public Mono<Long> intersectAndStore(K var1, Collection<K> var2, K var3);

    default public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey, Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Mono<Long> intersectAndStore(K var1, Collection<K> var2, K var3, Aggregate var4, Weights var5);

    default public Flux<V> union(K key, K otherKey) {
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<V> union(K var1, Collection<K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K key, K otherKey) {
        return this.unionWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K var1, Collection<K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K key, Collection<K> otherKeys, Aggregate aggregate) {
        return this.unionWithScores(key, otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(K var1, Collection<K> var2, Aggregate var3, Weights var4);

    public Mono<Long> unionAndStore(K var1, K var2, K var3);

    public Mono<Long> unionAndStore(K var1, Collection<K> var2, K var3);

    default public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey, Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Mono<Long> unionAndStore(K var1, Collection<K> var2, K var3, Aggregate var4, Weights var5);

    public Flux<V> rangeByLex(K var1, Range<String> var2);

    public Flux<V> rangeByLex(K var1, Range<String> var2, Limit var3);

    public Flux<V> reverseRangeByLex(K var1, Range<String> var2);

    public Flux<V> reverseRangeByLex(K var1, Range<String> var2, Limit var3);

    public Mono<Boolean> delete(K var1);
}

