/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.StreamMessage;
import io.lettuce.core.XClaimArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.models.stream.PendingMessage;
import io.lettuce.core.models.stream.PendingMessages;
import java.time.Duration;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;

class StreamConverters {
    StreamConverters() {
    }

    static XReadArgs toReadArgs(StreamReadOptions readOptions) {
        return StreamReadOptionsToXReadArgsConverter.INSTANCE.convert(readOptions);
    }

    static XClaimArgs toXClaimArgs(RedisStreamCommands.XClaimOptions options) {
        return XClaimOptionsToXClaimArgsConverter.INSTANCE.convert(options);
    }

    static Converter<StreamMessage<byte[], byte[]>, ByteRecord> byteRecordConverter() {
        return it -> StreamRecords.newRecord().in((byte[])it.getStream()).withId(it.getId()).ofBytes(it.getBody());
    }

    static org.springframework.data.redis.connection.stream.PendingMessages toPendingMessages(String groupName, Range<?> range, List<PendingMessage> source) {
        List<org.springframework.data.redis.connection.stream.PendingMessage> messages = source.stream().map(it -> {
            RecordId id = RecordId.of(it.getId());
            Consumer consumer = Consumer.from(groupName, it.getConsumer());
            return new org.springframework.data.redis.connection.stream.PendingMessage(id, consumer, Duration.ofMillis(it.getMsSinceLastDelivery()), it.getRedeliveryCount());
        }).toList();
        return new org.springframework.data.redis.connection.stream.PendingMessages(groupName, messages).withinRange(range);
    }

    static PendingMessagesSummary toPendingMessagesInfo(String groupName, PendingMessages source) {
        Range range = source.getMessageIds().isUnbounded() ? Range.unbounded() : Range.open((Object)((String)source.getMessageIds().getLower().getValue()), (Object)((String)source.getMessageIds().getUpper().getValue()));
        return new PendingMessagesSummary(groupName, source.getCount(), (Range<String>)range, source.getConsumerMessageCount());
    }

    static enum StreamReadOptionsToXReadArgsConverter implements Converter<StreamReadOptions, XReadArgs>
    {
        INSTANCE;


        public XReadArgs convert(StreamReadOptions source) {
            XReadArgs args = new XReadArgs();
            if (source.isNoack()) {
                args.noack(true);
            }
            if (source.getBlock() != null) {
                args.block(source.getBlock().longValue());
            }
            if (source.getCount() != null) {
                args.count(source.getCount().longValue());
            }
            return args;
        }
    }

    static enum XClaimOptionsToXClaimArgsConverter implements Converter<RedisStreamCommands.XClaimOptions, XClaimArgs>
    {
        INSTANCE;


        public XClaimArgs convert(RedisStreamCommands.XClaimOptions source) {
            XClaimArgs args = XClaimArgs.Builder.minIdleTime((Duration)source.getMinIdleTime());
            args.minIdleTime(source.getMinIdleTime());
            args.force(source.isForce());
            if (source.getIdleTime() != null) {
                args.idle(source.getIdleTime());
            }
            if (source.getRetryCount() != null) {
                args.retryCount(source.getRetryCount().longValue());
            }
            if (source.getUnixTime() != null) {
                args.time((TemporalAccessor)source.getUnixTime());
            }
            return args;
        }
    }
}

