/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.Cursor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConvertingCursor<S, T>
implements Cursor<T> {
    private Cursor<S> delegate;
    private Converter<S, T> converter;

    public ConvertingCursor(Cursor<S> cursor, Converter<S, T> converter) {
        Assert.notNull(cursor, (String)"Cursor must not be null");
        Assert.notNull(converter, (String)"Converter must not be null");
        this.delegate = cursor;
        this.converter = converter;
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Nullable
    public T next() {
        return (T)this.converter.convert(this.delegate.next());
    }

    public void remove() {
        this.delegate.remove();
    }

    public void close() {
        this.delegate.close();
    }

    @Override
    public long getCursorId() {
        return this.delegate.getCursorId();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public Cursor<T> open() {
        this.delegate = this.delegate.open();
        return this;
    }

    @Override
    public long getPosition() {
        return this.delegate.getPosition();
    }
}

