/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.PendingMessages;
import org.springframework.data.redis.connection.stream.PendingMessagesSummary;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.params.XAddParams;

class JedisStreamCommands
implements RedisStreamCommands {
    private final JedisConnection connection;

    JedisStreamCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)group, (String)"Group name must not be null or empty!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        return this.connection.invoke().just(BinaryJedis::xack, PipelineBase::xack, key, JedisConverters.toBytes(group), StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record, RedisStreamCommands.XAddOptions options) {
        Assert.notNull(record, (String)"Record must not be null!");
        Assert.notNull(record.getStream(), (String)"Stream must not be null!");
        XAddParams xAddParams = new XAddParams();
        xAddParams.id(record.getId().getValue());
        if (options.hasMaxlen()) {
            xAddParams.maxLen(options.getMaxlen().longValue());
        }
        if (options.isNoMkStream()) {
            xAddParams.noMkStream();
        }
        return (RecordId)this.connection.invoke().from(BinaryJedis::xadd, PipelineBase::xadd, record.getStream(), record.getValue(), xAddParams).get(it -> RecordId.of(JedisConverters.toString(it)));
    }

    @Override
    public List<RecordId> xClaimJustId(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        throw new UnsupportedOperationException("Jedis does not support xClaimJustId.");
    }

    @Override
    public List<ByteRecord> xClaim(byte[] key, String group, String newOwner, RedisStreamCommands.XClaimOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)group, (String)"Group must not be null!");
        Assert.notNull((Object)newOwner, (String)"NewOwner must not be null!");
        long minIdleTime = options.getMinIdleTime() == null ? -1L : options.getMinIdleTime().toMillis();
        int retryCount = options.getRetryCount() == null ? -1 : options.getRetryCount().intValue();
        long unixTime = options.getUnixTime() == null ? -1L : options.getUnixTime().toEpochMilli();
        return (List)this.connection.invoke().from(it -> it.xclaim(key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), minIdleTime, unixTime, retryCount, options.isForce(), StreamConverters.entryIdsToBytes(options.getIds())), it -> it.xclaim(key, JedisConverters.toBytes(group), JedisConverters.toBytes(newOwner), minIdleTime, unixTime, retryCount, options.isForce(), StreamConverters.entryIdsToBytes(options.getIds()))).get(r -> StreamConverters.convertToByteRecord(key, r));
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        return this.connection.invoke().just(BinaryJedis::xdel, PipelineBase::xdel, key, StreamConverters.entryIdsToBytes(Arrays.asList(recordIds)));
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        return this.xGroupCreate(key, groupName, readOffset, false);
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset, boolean mkStream) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty!");
        Assert.notNull((Object)readOffset, (String)"ReadOffset must not be null!");
        return this.connection.invoke().just(BinaryJedis::xgroupCreate, PipelineBase::xgroupCreate, key, JedisConverters.toBytes(groupName), JedisConverters.toBytes(readOffset.getOffset()), mkStream);
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        return (Boolean)this.connection.invoke().from(BinaryJedis::xgroupDelConsumer, PipelineBase::xgroupDelConsumer, key, JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName())).get(r -> r > 0L);
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty!");
        return (Boolean)this.connection.invoke().from(BinaryJedis::xgroupDestroy, PipelineBase::xgroupDestroy, key, JedisConverters.toBytes(groupName)).get(r -> r > 0L);
    }

    @Override
    public StreamInfo.XInfoStream xInfo(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'XINFO' cannot be called in pipeline / transaction mode.");
        }
        return this.connection.invoke().just(it -> {
            StreamInfo streamInfo = it.xinfoStream(key);
            return StreamInfo.XInfoStream.fromList(StreamConverters.mapToList(streamInfo.getStreamInfo()));
        });
    }

    @Override
    public StreamInfo.XInfoGroups xInfoGroups(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'XINFO GROUPS' cannot be called in pipeline / transaction mode.");
        }
        return this.connection.invoke().just(it -> {
            List streamGroupInfos = it.xinfoGroup(key);
            ArrayList<Object> sources = new ArrayList<Object>();
            streamGroupInfos.forEach(streamGroupInfo -> sources.add(StreamConverters.mapToList(streamGroupInfo.getGroupInfo())));
            return StreamInfo.XInfoGroups.fromList(sources);
        });
    }

    @Override
    public StreamInfo.XInfoConsumers xInfoConsumers(byte[] key, String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'XINFO CONSUMERS' cannot be called in pipeline / transaction mode.");
        }
        return this.connection.invoke().just(it -> {
            List streamConsumersInfos = it.xinfoConsumers(key, JedisConverters.toBytes(groupName));
            ArrayList<Object> sources = new ArrayList<Object>();
            streamConsumersInfos.forEach(streamConsumersInfo -> sources.add(StreamConverters.mapToList(streamConsumersInfo.getConsumerInfo())));
            return StreamInfo.XInfoConsumers.fromList(groupName, sources);
        });
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::xlen, PipelineBase::xlen, key);
    }

    @Override
    public PendingMessagesSummary xPending(byte[] key, String groupName) {
        throw new UnsupportedOperationException("Jedis does not support returning PendingMessagesSummary.");
    }

    @Override
    public PendingMessages xPending(byte[] key, String groupName, RedisStreamCommands.XPendingOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"GroupName must not be null!");
        Range<?> range = options.getRange();
        byte[] group = JedisConverters.toBytes(groupName);
        return (PendingMessages)this.connection.invoke().from((it, t1, t2, t3, t4, t5, t6) -> {
            List r = it.xpending(t1, t2, t3, t4, t5.intValue(), t6);
            return (List)BuilderFactory.STREAM_PENDING_ENTRY_LIST.build((Object)r);
        }, PipelineBase::xpending, key, group, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), options.getCount().intValue(), JedisConverters.toBytes(options.getConsumerName())).get(r -> StreamConverters.toPendingMessages(groupName, range, r));
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        return (List)this.connection.invoke().from(it -> it.xrange(key, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), count), it -> it.xrange(key, JedisConverters.toBytes(StreamConverters.getLowerValue(range)), JedisConverters.toBytes(StreamConverters.getUpperValue(range)), count)).get(r -> StreamConverters.convertToByteRecord(key, r));
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'XREAD' cannot be called in pipeline / transaction mode.");
        }
        long block = readOptions.getBlock() == null ? -1L : readOptions.getBlock();
        int count = readOptions.getCount() != null ? readOptions.getCount().intValue() : Integer.MAX_VALUE;
        return this.connection.invoke().from(it -> it.xread(count, block, StreamConverters.toStreamOffsets(streams))).getOrElse(StreamConverters::convertToByteRecords, Collections::emptyList);
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'XREADGROUP' cannot be called in pipeline / transaction mode.");
        }
        long block = readOptions.getBlock() == null ? -1L : readOptions.getBlock();
        int count = readOptions.getCount() == null ? -1 : readOptions.getCount().intValue();
        return this.connection.invoke().from(it -> it.xreadGroup(JedisConverters.toBytes(consumer.getGroup()), JedisConverters.toBytes(consumer.getName()), count, block, readOptions.isNoack(), StreamConverters.toStreamOffsets(streams))).getOrElse(StreamConverters::convertToByteRecords, Collections::emptyList);
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        int count = limit.isUnlimited() ? Integer.MAX_VALUE : limit.getCount();
        return (List)this.connection.invoke().from(BinaryJedis::xrevrange, PipelineBase::xrevrange, key, JedisConverters.toBytes(StreamConverters.getUpperValue(range)), JedisConverters.toBytes(StreamConverters.getLowerValue(range)), count).get(it -> StreamConverters.convertToByteRecord(key, it));
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        return this.xTrim(key, count, false);
    }

    @Override
    public Long xTrim(byte[] key, long count, boolean approximateTrimming) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::xtrim, PipelineBase::xtrim, key, count, approximateTrimming);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

