/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.BinaryRedisPipeline;
import redis.clients.jedis.params.SetParams;

class JedisStringCommands
implements RedisStringCommands {
    private final JedisConnection connection;

    JedisStringCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] get(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::get, PipelineBase::get, key);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::getSet, PipelineBase::getSet, key, value);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        return this.connection.invoke().just(BinaryJedis::mget, MultiKeyPipelineBase::mget, keys);
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().from(BinaryJedis::set, PipelineBase::set, key, value).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null!");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null!");
        SetParams params = JedisConverters.toSetCommandExPxArgument(expiration, JedisConverters.toSetCommandNxXxArgument(option));
        return this.connection.invoke().from(BinaryJedis::set, PipelineBase::set, key, value, params).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().from(BinaryJedis::setnx, PipelineBase::setnx, key, value).get(Converters.longToBoolean());
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Time must be less than Integer.MAX_VALUE for setEx in Jedis.");
        }
        return this.connection.invoke().from(BinaryJedisCommands::setex, BinaryRedisPipeline::setex, key, (int)seconds, value).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().from(BinaryJedis::psetex, PipelineBase::psetex, key, milliseconds, value).getOrElse(Converters.stringToBooleanConverter(), () -> false);
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        return this.connection.invoke().from(BinaryJedis::mset, MultiKeyPipelineBase::mset, JedisConverters.toByteArrays(tuples)).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        return this.connection.invoke().from(BinaryJedis::msetnx, MultiKeyPipelineBase::msetnx, JedisConverters.toByteArrays(tuples)).get(Converters.longToBoolean());
    }

    @Override
    public Long incr(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::incr, PipelineBase::incr, key);
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::incrBy, PipelineBase::incrBy, key, value);
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::incrByFloat, PipelineBase::incrByFloat, key, value);
    }

    @Override
    public Long decr(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::decr, PipelineBase::decr, key);
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::decrBy, PipelineBase::decrBy, key, value);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().just(BinaryJedis::append, PipelineBase::append, key, value);
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::getrange, PipelineBase::getrange, key, start, end);
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.connection.invokeStatus().just(BinaryJedis::setrange, PipelineBase::setrange, key, offset, value);
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::getbit, PipelineBase::getbit, key, offset);
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::setbit, PipelineBase::setbit, key, offset, JedisConverters.toBit(value));
    }

    @Override
    public Long bitCount(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::bitcount, PipelineBase::bitcount, key);
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::bitcount, PipelineBase::bitcount, key, start, end);
    }

    @Override
    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)subCommands, (String)"Command must not be null!");
        return this.connection.invoke().just(BinaryJedis::bitfield, PipelineBase::bitfield, key, JedisConverters.toBitfieldCommandArguments(subCommands));
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Assert.notNull((Object)((Object)op), (String)"BitOperation must not be null!");
        Assert.notNull((Object)destination, (String)"Destination key must not be null!");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        return this.connection.invoke().just(BinaryJedis::bitop, MultiKeyPipelineBase::bitop, JedisConverters.toBitOp(op), destination, keys);
    }

    @Override
    @Nullable
    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null! Use Range.unbounded() instead.");
        if (range.getLowerBound().isBounded()) {
            BitPosParams params = range.getUpperBound().isBounded() ? new BitPosParams(((Long)range.getLowerBound().getValue().get()).longValue(), ((Long)range.getUpperBound().getValue().get()).longValue()) : new BitPosParams(((Long)range.getLowerBound().getValue().get()).longValue());
            return this.connection.invoke().just(BinaryJedis::bitpos, PipelineBase::bitpos, key, bit, params);
        }
        return this.connection.invoke().just(BinaryJedis::bitpos, PipelineBase::bitpos, key, bit);
    }

    @Override
    public Long strLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().just(BinaryJedis::strlen, PipelineBase::strlen, key);
    }
}

