/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.springframework.util.Assert;

public class Consumer {
    private final String group;
    private final String name;

    private Consumer(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public static Consumer from(String group, String name) {
        Assert.hasText((String)group, (String)"Group must not be null");
        Assert.hasText((String)name, (String)"Name must not be null");
        return new Consumer(group, name);
    }

    public String toString() {
        return String.format("%s:%s", this.group, this.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Consumer)) {
            return false;
        }
        Consumer other = (Consumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Consumer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }
}

