/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Properties;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RedisServer
extends RedisNode {
    private Properties properties;

    public RedisServer(String host, int port) {
        this(host, port, new Properties());
    }

    public RedisServer(String host, int port, Properties properties) {
        super(host, port);
        this.properties = properties;
        String name = host + ":" + port;
        if (properties != null && properties.containsKey(INFO.NAME.key)) {
            name = this.get(INFO.NAME);
        }
        this.setName(name);
    }

    public static RedisServer newServerFrom(Properties properties) {
        String host = properties.getProperty(INFO.HOST.key, "127.0.0.1");
        int port = Integer.parseInt(properties.getProperty(INFO.PORT.key, "26379"));
        return new RedisServer(host, port, properties);
    }

    public void setQuorum(Long quorum) {
        if (quorum == null) {
            this.properties.remove(INFO.QUORUM.key);
            return;
        }
        this.properties.put(INFO.QUORUM.key, quorum.toString());
    }

    public String getRunId() {
        return this.get(INFO.RUN_ID);
    }

    public String getFlags() {
        return this.get(INFO.FLAGS);
    }

    @Override
    public boolean isMaster() {
        String role = this.getRoleReported();
        if (!StringUtils.hasText((String)role)) {
            return false;
        }
        return role.equalsIgnoreCase("master");
    }

    public Long getPendingCommands() {
        return this.getLongValueOf(INFO.PENDING_COMMANDS);
    }

    public Long getLastPingSent() {
        return this.getLongValueOf(INFO.LAST_PING_SENT);
    }

    public Long getLastOkPingReply() {
        return this.getLongValueOf(INFO.LAST_OK_PING_REPLY);
    }

    public Long getDownAfterMilliseconds() {
        return this.getLongValueOf(INFO.DOWN_AFTER_MILLISECONDS);
    }

    public Long getInfoRefresh() {
        return this.getLongValueOf(INFO.INFO_REFRESH);
    }

    public String getRoleReported() {
        return this.get(INFO.ROLE_REPORTED);
    }

    public Long roleReportedTime() {
        return this.getLongValueOf(INFO.ROLE_REPORTED_TIME);
    }

    public Long getConfigEpoch() {
        return this.getLongValueOf(INFO.CONFIG_EPOCH);
    }

    public Long getNumberSlaves() {
        return this.getNumberReplicas();
    }

    public Long getNumberReplicas() {
        return this.getLongValueOf(INFO.NUMBER_SLAVES);
    }

    public Long getNumberOtherSentinels() {
        return this.getLongValueOf(INFO.NUMBER_OTHER_SENTINELS);
    }

    public Long getQuorum() {
        return this.getLongValueOf(INFO.QUORUM);
    }

    public Long getFailoverTimeout() {
        return this.getLongValueOf(INFO.FAILOVER_TIMEOUT);
    }

    public Long getParallelSyncs() {
        return this.getLongValueOf(INFO.PARALLEL_SYNCS);
    }

    public String get(INFO info) {
        Assert.notNull((Object)((Object)info), (String)"Cannot retrieve client information for 'null'.");
        return this.get(info.key);
    }

    public String get(String key) {
        Assert.hasText((String)key, (String)"Cannot get information for 'empty' / 'null' key.");
        return this.properties.getProperty(key);
    }

    private Long getLongValueOf(INFO info) {
        String value = this.get(info);
        return value == null ? null : Long.valueOf(value);
    }

    public static enum INFO {
        NAME("name"),
        HOST("ip"),
        PORT("port"),
        RUN_ID("runid"),
        FLAGS("flags"),
        PENDING_COMMANDS("pending-commands"),
        LAST_PING_SENT("last-ping-sent"),
        LAST_OK_PING_REPLY("last-ok-ping-reply"),
        DOWN_AFTER_MILLISECONDS("down-after-milliseconds"),
        INFO_REFRESH("info-refresh"),
        ROLE_REPORTED("role-reported"),
        ROLE_REPORTED_TIME("role-reported-time"),
        CONFIG_EPOCH("config-epoch"),
        NUMBER_SLAVES("num-slaves"),
        NUMBER_OTHER_SENTINELS("num-other-sentinels"),
        BUFFER_LENGTH("qbuf"),
        BUFFER_FREE_SPACE("qbuf-free"),
        OUTPUT_BUFFER_LENGTH("obl"),
        OUTPUT_LIST_LENGTH("number-other-sentinels"),
        QUORUM("quorum"),
        FAILOVER_TIMEOUT("failover-timeout"),
        PARALLEL_SYNCS("parallel-syncs");

        String key;

        private INFO(String key) {
            this.key = key;
        }
    }
}

