/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.redis.repository.query.RedisOperationChain;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.CollectionUtils;

public class RedisQueryCreator
extends AbstractQueryCreator<KeyValueQuery<RedisOperationChain>, RedisOperationChain> {
    public RedisQueryCreator(PartTree tree, ParameterAccessor parameters) {
        super(tree, parameters);
    }

    protected RedisOperationChain create(Part part, Iterator<Object> iterator) {
        return this.from(part, iterator, new RedisOperationChain());
    }

    private RedisOperationChain from(Part part, Iterator<Object> iterator, RedisOperationChain sink) {
        switch (part.getType()) {
            case SIMPLE_PROPERTY: {
                sink.sismember(part.getProperty().toDotPath(), iterator.next());
                break;
            }
            default: {
                throw new IllegalArgumentException(part.getType() + "is not supported for redis query derivation");
            }
        }
        return sink;
    }

    protected RedisOperationChain and(Part part, RedisOperationChain base, Iterator<Object> iterator) {
        return this.from(part, iterator, base);
    }

    protected RedisOperationChain or(RedisOperationChain base, RedisOperationChain criteria) {
        base.orSismember(criteria.getSismember());
        return base;
    }

    protected KeyValueQuery<RedisOperationChain> complete(RedisOperationChain criteria, Sort sort) {
        KeyValueQuery query = new KeyValueQuery((Object)criteria);
        if (query.getCritieria() != null && !CollectionUtils.isEmpty(((RedisOperationChain)query.getCritieria()).getSismember()) && !CollectionUtils.isEmpty(((RedisOperationChain)query.getCritieria()).getOrSismember()) && ((RedisOperationChain)query.getCritieria()).getSismember().size() == 1 && ((RedisOperationChain)query.getCritieria()).getOrSismember().size() == 1) {
            ((RedisOperationChain)query.getCritieria()).getOrSismember().add(((RedisOperationChain)query.getCritieria()).getSismember().iterator().next());
            ((RedisOperationChain)query.getCritieria()).getSismember().clear();
        }
        if (sort != null) {
            query.setSort(sort);
        }
        return query;
    }
}

