/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.util.Assert;

public class RedisData {
    private String keyspace;
    private String id;
    private Bucket bucket;
    private Set<IndexedData> indexedData;
    private Long timeToLive;

    public RedisData() {
        this(Collections.emptyMap());
    }

    public RedisData(Map<byte[], byte[]> raw) {
        this(Bucket.newBucketFromRawMap(raw));
    }

    public RedisData(Bucket bucket) {
        Assert.notNull((Object)bucket, (String)"Bucket must not be null!");
        this.bucket = bucket;
        this.indexedData = new HashSet<IndexedData>();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public void addIndexedData(IndexedData index) {
        Assert.notNull((Object)index, (String)"IndexedData to add must not be null!");
        this.indexedData.add(index);
    }

    public Set<IndexedData> getIndexedData() {
        return Collections.unmodifiableSet(this.indexedData);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToLive(Long timeToLive, TimeUnit timeUnit) {
        Assert.notNull((Object)timeToLive, (String)"TimeToLive must not be null when used with TimeUnit!");
        Assert.notNull((Object)timeToLive, (String)"TimeUnit must not be null!");
        this.setTimeToLive(TimeUnit.SECONDS.convert(timeToLive, timeUnit));
    }

    public String toString() {
        return "RedisDataObject [key=" + this.keyspace + ":" + this.id + ", hash=" + this.bucket + "]";
    }
}

