/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.r2dbc.repository.R2dbcRepository;
import org.springframework.data.r2dbc.repository.support.R2dbcRepositoryFactoryBean;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.core.RepositoryMetadata;

public class R2dbcRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    public String getModuleName() {
        return "R2DBC";
    }

    protected String getModulePrefix() {
        return "r2dbc";
    }

    public String getRepositoryFactoryBeanClassName() {
        return R2dbcRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Table.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(R2dbcRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("entityOperations", attributes.getString("entityOperationsRef"));
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return metadata.isReactiveRepository();
    }
}

