/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.R2dbcConverters;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.R2dbcSimpleTypeHolder;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class R2dbcCustomConversions
extends CustomConversions {
    public static final List<Object> STORE_CONVERTERS;
    public static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public R2dbcCustomConversions(CustomConversions.StoreConversions storeConversions, Collection<?> converters) {
        super((CustomConversions.ConverterConfiguration)new R2dbcCustomConversionsConfiguration(storeConversions, converters instanceof List ? (List<Object>)converters : new ArrayList(converters)));
    }

    protected R2dbcCustomConversions(CustomConversions.ConverterConfiguration converterConfiguration) {
        super(converterConfiguration);
    }

    public static R2dbcCustomConversions of(R2dbcDialect dialect, Object ... converters) {
        return R2dbcCustomConversions.of(dialect, Arrays.asList(converters));
    }

    public static R2dbcCustomConversions of(R2dbcDialect dialect, Collection<?> converters) {
        return R2dbcCustomConversions.create(dialect, configurer -> configurer.registerConverters(converters));
    }

    public static R2dbcCustomConversions create(R2dbcDialect dialect, Consumer<R2dbcConverterConfigurer> configurer) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(configurer, (String)"R2dbcConverterConfigurer Consumer must not be null");
        R2dbcConverterConfigurer converterConfigurer = R2dbcConverterConfigurer.from(dialect);
        configurer.accept(converterConfigurer);
        return new R2dbcCustomConversions(converterConfigurer.createConfiguration());
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>(R2dbcConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)R2dbcSimpleTypeHolder.HOLDER, STORE_CONVERTERS);
    }

    static class R2dbcCustomConversionsConfiguration
    extends CustomConversions.ConverterConfiguration {
        public R2dbcCustomConversionsConfiguration(CustomConversions.StoreConversions storeConversions, List<?> userConverters) {
            super(storeConversions, userConverters, convertiblePair -> !convertiblePair.getSourceType().getName().startsWith("java.time.") || !convertiblePair.getTargetType().equals(Date.class));
        }
    }

    public static class R2dbcConverterConfigurer {
        private final CustomConversions.StoreConversions storeConversions;
        private final List<Object> customConverters = new ArrayList<Object>();

        private R2dbcConverterConfigurer(CustomConversions.StoreConversions storeConversions) {
            this.storeConversions = storeConversions;
        }

        static R2dbcConverterConfigurer from(R2dbcDialect dialect) {
            ArrayList<Object> converters = new ArrayList<Object>();
            converters.addAll(dialect.getConverters());
            converters.addAll(STORE_CONVERTERS);
            CustomConversions.StoreConversions storeConversions = CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), converters);
            return new R2dbcConverterConfigurer(storeConversions);
        }

        static R2dbcConverterConfigurer from(CustomConversions.StoreConversions storeConversions) {
            return new R2dbcConverterConfigurer(storeConversions);
        }

        @Contract(value="_ -> this")
        public R2dbcConverterConfigurer registerConverter(Converter<?, ?> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            this.customConverters.add(converter);
            return this;
        }

        @Contract(value="_ -> this")
        public R2dbcConverterConfigurer registerConverters(Object ... converters) {
            return this.registerConverters(Arrays.asList(converters));
        }

        @Contract(value="_ -> this")
        public R2dbcConverterConfigurer registerConverters(Collection<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            Assert.noNullElements(converters, (String)"Converters must not be null nor contain null values");
            this.customConverters.addAll(converters);
            return this;
        }

        @Contract(value="_ -> this")
        public R2dbcConverterConfigurer registerConverterFactory(ConverterFactory<?, ?> converterFactory) {
            Assert.notNull(converterFactory, (String)"ConverterFactory must not be null");
            this.customConverters.add(converterFactory);
            return this;
        }

        CustomConversions.ConverterConfiguration createConfiguration() {
            return new R2dbcCustomConversionsConfiguration(this.storeConversions, this.customConverters);
        }
    }
}

