/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import reactor.core.publisher.Mono;

class SequenceEntityCallbackDelegate {
    private static final Log LOG = LogFactory.getLog(SequenceEntityCallbackDelegate.class);
    private final Dialect dialect;
    private final DatabaseClient databaseClient;

    public SequenceEntityCallbackDelegate(Dialect dialect, DatabaseClient databaseClient) {
        this.dialect = dialect;
        this.databaseClient = databaseClient;
    }

    protected Mono<Object> generateSequenceValue(RelationalPersistentProperty property, OutboundRow row, PersistentPropertyAccessor<Object> accessor) {
        Class targetType = ClassUtils.resolvePrimitiveIfNecessary((Class)property.getType());
        return this.getSequenceValue(property).map(it -> {
            Object sequenceValue = it;
            if (sequenceValue instanceof Number && Number.class.isAssignableFrom(targetType)) {
                sequenceValue = NumberUtils.convertNumberToTargetClass((Number)((Number)sequenceValue), (Class)targetType);
            }
            row.append(property.getColumnName(), Parameter.from((Object)sequenceValue));
            accessor.setProperty((PersistentProperty)property, sequenceValue);
            return accessor.getBean();
        });
    }

    protected boolean hasValue(PersistentProperty<?> property, PersistentPropertyAccessor<Object> propertyAccessor) {
        Object identifier = propertyAccessor.getProperty(property);
        if (property.getType().isPrimitive()) {
            Object primitiveDefault = ReflectionUtils.getPrimitiveDefault((Class)property.getType());
            return !primitiveDefault.equals(identifier);
        }
        return identifier != null;
    }

    private Mono<Object> getSequenceValue(RelationalPersistentProperty property) {
        SqlIdentifier sequence = property.getSequence();
        if (sequence != null && !this.dialect.getIdGeneration().sequencesSupported()) {
            LOG.warn((Object)"Entity type '%s' is marked for sequence usage but configured dialect '%s'\ndoes not support sequences. Falling back to identity columns.\n".formatted(property.getOwner().getType(), ClassUtils.getQualifiedName(this.dialect.getClass())));
            return Mono.empty();
        }
        String sql = this.dialect.getIdGeneration().createSequenceQuery(sequence);
        return this.databaseClient.sql(sql).map((r, rowMetadata) -> r.get(0)).one();
    }
}

