/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcSpELExpressionEvaluator;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.r2dbc.core.binding.BindTarget;

class ExpressionEvaluatingParameterBinder {
    private final ExpressionQuery expressionQuery;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final Map<String, Boolean> namedParameters = new ConcurrentHashMap<String, Boolean>();

    ExpressionEvaluatingParameterBinder(ExpressionQuery expressionQuery, ReactiveDataAccessStrategy dataAccessStrategy) {
        this.expressionQuery = expressionQuery;
        this.dataAccessStrategy = dataAccessStrategy;
    }

    void bind(BindTarget bindTarget, RelationalParameterAccessor parameterAccessor, R2dbcSpELExpressionEvaluator evaluator) {
        Object[] values = parameterAccessor.getValues();
        Parameters bindableParameters = parameterAccessor.getBindableParameters();
        this.bindExpressions(bindTarget, evaluator);
        this.bindParameters(bindTarget, parameterAccessor.hasBindableNullValue(), values, bindableParameters);
    }

    private void bindExpressions(BindTarget bindSpec, R2dbcSpELExpressionEvaluator evaluator) {
        for (ExpressionQuery.ParameterBinding binding : this.expressionQuery.getBindings()) {
            org.springframework.r2dbc.core.Parameter valueForBinding = this.getBindValue(evaluator.evaluate(binding.getExpression()));
            ExpressionEvaluatingParameterBinder.bind(bindSpec, binding.getParameterName(), valueForBinding);
        }
    }

    private void bindParameters(BindTarget bindSpec, boolean hasBindableNullValue, Object[] values, Parameters<?, ?> bindableParameters) {
        int bindingIndex = 0;
        for (Parameter bindableParameter : bindableParameters) {
            org.springframework.r2dbc.core.Parameter parameter;
            Optional name = bindableParameter.getName();
            if (name.isPresent() && this.isNamedParameterReferencedFromQuery(name) || !this.expressionQuery.getBindings().isEmpty()) {
                if (!this.isNamedParameterReferencedFromQuery(name) || (parameter = this.getBindValue(values, bindableParameter)).isEmpty() && !hasBindableNullValue) continue;
                ExpressionEvaluatingParameterBinder.bind(bindSpec, (String)name.get(), parameter);
                continue;
            }
            parameter = this.getBindValue(values, bindableParameter);
            if (parameter.isEmpty() && !hasBindableNullValue) continue;
            ExpressionEvaluatingParameterBinder.bind(bindSpec, bindingIndex++, parameter);
        }
    }

    private org.springframework.r2dbc.core.Parameter getBindValue(Object[] values, Parameter bindableParameter) {
        org.springframework.r2dbc.core.Parameter parameter = org.springframework.r2dbc.core.Parameter.fromOrEmpty((Object)values[bindableParameter.getIndex()], (Class)bindableParameter.getType());
        return this.dataAccessStrategy.getBindValue(parameter);
    }

    private static void bind(BindTarget spec, String name, org.springframework.r2dbc.core.Parameter parameter) {
        Object value = parameter.getValue();
        if (value == null) {
            spec.bindNull(name, parameter.getType());
        } else {
            spec.bind(name, value);
        }
    }

    private static void bind(BindTarget spec, int index, org.springframework.r2dbc.core.Parameter parameter) {
        Object value = parameter.getValue();
        if (value == null) {
            spec.bindNull(index, parameter.getType());
        } else {
            spec.bind(index, value);
        }
    }

    private org.springframework.r2dbc.core.Parameter getBindValue(org.springframework.r2dbc.core.Parameter bindValue) {
        return this.dataAccessStrategy.getBindValue(bindValue);
    }

    private boolean isNamedParameterReferencedFromQuery(Optional<String> name) {
        if (!name.isPresent()) {
            return false;
        }
        return this.namedParameters.computeIfAbsent(name.get(), it -> {
            Pattern namedParameterPattern = Pattern.compile("(\\W)[:#$@]" + Pattern.quote(it) + "(\\W|$)");
            return namedParameterPattern.matcher(this.expressionQuery.getQuery()).find();
        });
    }
}

